/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.stash.internal.backup.liquibase.ChangeSetIdGenerator;
import com.atlassian.stash.internal.backup.liquibase.ColumnSerialisationType;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseXmlWriter;
import com.atlassian.stash.internal.backup.liquibase.xml.DelegatingXmlStreamWriter;
import com.atlassian.stash.internal.backup.liquibase.xml.XmlEncoder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class DefaultLiquibaseXmlWriter
extends DelegatingXmlStreamWriter<XMLStreamWriter>
implements LiquibaseXmlWriter {
    private final ChangeSetIdGenerator idGenerator;
    private final String changeSetAuthor;
    private final XmlEncoder xmlEncoder;

    DefaultLiquibaseXmlWriter(XMLStreamWriter delegate, ChangeSetIdGenerator idGenerator, String changeSetAuthor, XmlEncoder xmlEncoder) {
        super(delegate);
        this.idGenerator = idGenerator;
        this.changeSetAuthor = changeSetAuthor;
        this.xmlEncoder = xmlEncoder;
    }

    @Override
    public void writeDatabaseChangeLogStartElement() throws XMLStreamException {
        this.writeStartElement("databaseChangeLog");
    }

    @Override
    public void writeChangeSetToDeleteRowsFromTable(@Nonnull String tableName) throws XMLStreamException {
        this.writeChangeSetStartElement(tableName);
        this.writeDeleteAll(tableName);
        this.writeEndElement();
    }

    @Override
    public void writeChangeSetStartElement(@Nonnull String tableName) throws XMLStreamException {
        this.writeStartElement("changeSet");
        this.writeAttribute("id", this.idGenerator.next(tableName));
        this.writeAttribute("author", this.changeSetAuthor);
    }

    private void writeDeleteAll(String tableName) throws XMLStreamException {
        this.writeStartElement("delete");
        this.writeAttribute("tableName", tableName.toLowerCase());
        this.writeEmptyElement("where");
        this.writeEndElement();
    }

    @Override
    public void writeColumn(@Nonnull String columnName, @Nullable Object value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        this.writeStartElement("column");
        this.writeAttribute("name", columnName);
        ColumnSerialisationType columnSerialisationType = ColumnSerialisationType.ofValue(value);
        this.writeAttribute("colType", columnSerialisationType.toString());
        this.writeCData(this.xmlEncoder.encodeForCdata(columnSerialisationType.toColumnString(value)));
        this.writeEndElement();
    }

    ChangeSetIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    String getChangeSetAuthor() {
        return this.changeSetAuthor;
    }
}

