/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.AbstractDaoImpl;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="stashUserDao")
public class StashUserDaoImpl
extends AbstractDaoImpl<Integer, InternalStashUser>
implements StashUserDao {
    private static final String FIELD_USERNAME = "username";

    @Autowired
    public StashUserDaoImpl(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public Page<InternalStashUser> findAllByContainedText(String containedText, PageRequest pageRequest) {
        return this.findAllByContainedText(containedText, pageRequest, (Predicate<? super InternalStashUser>)Predicates.alwaysTrue());
    }

    public Page<InternalStashUser> findAllByContainedText(String containedText, PageRequest pageRequest, Predicate<? super InternalStashUser> predicate) {
        if (StringUtils.isEmpty((String)containedText)) {
            return this.findAll(pageRequest, predicate);
        }
        Query query = this.session().createQuery("from InternalStashUser where username like :username order by username");
        query.setParameter(FIELD_USERNAME, (Object)("%" + IdentifierUtils.toLowerCase((String)containedText) + "%"));
        return this.pageQuery(query, pageRequest, predicate);
    }

    public InternalStashUser findByName(String username) {
        Query query = this.session().createQuery("from InternalStashUser where username = :username");
        query.setParameter(FIELD_USERNAME, (Object)IdentifierUtils.toLowerCase((String)username));
        return (InternalStashUser)query.uniqueResult();
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)FIELD_USERNAME);
    }
}

