/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.AbstractDaoImpl;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalRepositoryAccess;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.RepositoryAccessDao;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RepositoryAccessDaoImpl
extends AbstractDaoImpl<InternalRepositoryAccess.Key, InternalRepositoryAccess>
implements RepositoryAccessDao {
    private static Predicate<InternalRepositoryAccess> ALL = new Predicate<InternalRepositoryAccess>(){

        public boolean apply(@Nullable InternalRepositoryAccess repoAccess) {
            return true;
        }
    };

    @Autowired
    public RepositoryAccessDaoImpl(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public Page<InternalRepositoryAccess> findRecentlyAccessedRepositories(@Nonnull InternalStashUser user, @Nonnull PageRequest pageRequest, Predicate<InternalRepositoryAccess> predicate) {
        return this.pageCriteria(this.session().createCriteria(InternalRepositoryAccess.class).add((Criterion)Restrictions.eq((String)"user", (Object)user)).addOrder(this.getImplicitOrder()), pageRequest, predicate);
    }

    public void deleteAllAccessesForRepository(InternalRepository repository) {
        Query query = this.session().createQuery("delete InternalRepositoryAccess where repository = :repository");
        query.setParameter("repository", (Object)repository);
        query.executeUpdate();
    }

    public void trimToFirstPage(@Nonnull InternalStashUser user, int pageLimit, Predicate<InternalRepositoryAccess> predicate) {
        Page<InternalRepositoryAccess> repoAccesses = this.findRecentlyAccessedRepositories(user, (PageRequest)new PageRequestImpl(0, pageLimit), predicate == null ? ALL : predicate);
        if (!repoAccesses.getIsLastPage() && repoAccesses.getSize() > 0) {
            this.session().createQuery("delete InternalRepositoryAccess where user = :user and last_accessed < :minLastAccessed").setEntity("user", (Object)user).setLong("minLastAccessed", ((InternalRepositoryAccess)Iterables.getLast((Iterable)repoAccesses.getValues())).getLastAccessed().getTime()).executeUpdate();
        }
    }

    public void deleteAllAccessesForUser(@Nonnull InternalStashUser user) {
        Query query = this.session().createQuery("delete InternalRepositoryAccess where user= :user");
        query.setParameter("user", (Object)user);
        query.executeUpdate();
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.desc((String)"lastAccessed");
    }
}

