/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.AbstractDaoImpl;
import com.atlassian.stash.internal.user.GrantedPermissionDao;
import com.atlassian.stash.internal.user.GroupPermissionSearchCriteria;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalPermittedUser;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.PermissionFilterMode;
import com.atlassian.stash.internal.user.PermissionSearchCriteria;
import com.atlassian.stash.internal.user.UserPermissionSearchCriteria;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermittedGroup;
import com.atlassian.stash.user.PermittedUser;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageImpl;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.criterion.Subqueries;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="grantedPermissionDao")
public class GrantedPermissionDaoImpl
extends AbstractDaoImpl<Integer, InternalGrantedPermission>
implements GrantedPermissionDao {
    public static final Function<String, String> TO_LOWERCASE = new Function<String, String>(){

        public String apply(@Nullable String name) {
            return IdentifierUtils.toLowerCase((String)name);
        }
    };

    @Autowired
    public GrantedPermissionDaoImpl(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public int deleteAllGroupPermissions(@Nonnull String name) {
        Query query = this.session().createQuery("delete InternalGrantedPermission perm where perm.group = :group");
        query.setParameter("group", (Object)IdentifierUtils.toLowerCase((String)name));
        return query.executeUpdate();
    }

    public int deleteAllProjectPermissions(@Nonnull Integer projectId) {
        Query query = this.session().createQuery("delete InternalGrantedPermission perm where perm.project.id = :projectId");
        query.setParameter("projectId", (Object)projectId);
        return query.executeUpdate();
    }

    public int deleteAllUserPermissions(int userId) {
        Query query = this.session().createQuery("delete InternalGrantedPermission perm where perm.user.id = :userId");
        query.setParameter("userId", (Object)userId);
        return query.executeUpdate();
    }

    public int deleteGrantedPermissions(@Nonnull Permission permission, Integer project, Integer user, String group) {
        Query query = this.session().createQuery("delete InternalGrantedPermission perm where perm.permission = :permission and " + (project == null ? "perm.project is null " : "perm.project.id = :project ") + "and " + (user == null ? "perm.user is null " : "perm.user.id = :user ") + "and " + (group == null ? "perm.group is null " : "perm.group = :group "));
        query.setParameter("permission", (Object)permission);
        if (project != null) {
            query.setParameter("project", (Object)project);
        }
        if (user != null) {
            query.setParameter("user", (Object)user);
        }
        if (group != null) {
            query.setParameter("group", (Object)IdentifierUtils.toLowerCase((String)group));
        }
        return query.executeUpdate();
    }

    public Page<PermittedGroup> getPermittedGroups(@Nonnull GroupPermissionSearchCriteria searchCriteria, @Nonnull PageRequest pageRequest) {
        Page<String> page = this.searchGroups(searchCriteria, pageRequest, false);
        if (page.getIsLastPage() && page.getSize() == 0) {
            return PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        }
        Query query = this.session().createQuery("select new com.atlassian.stash.internal.user.InternalPermittedGroup(p.group, max(w.weight)) from InternalGrantedPermission p, InternalWeightedPermission w where p.permission = w.id and p.group in (:groups) " + this.calcProjectClause((PermissionSearchCriteria)searchCriteria) + "group by p.group " + "order by p.group");
        query.setParameterList("groups", Collections2.transform((Collection)ImmutableList.copyOf((Iterable)page.getValues()), TO_LOWERCASE));
        if (searchCriteria.hasProjectId()) {
            query.setParameter("projectId", (Object)searchCriteria.getProjectId());
        }
        List groups = query.list();
        return new PageImpl(pageRequest, groups.size(), (Iterable)groups, page.getIsLastPage());
    }

    public Page<PermittedUser> getPermittedUsers(@Nonnull UserPermissionSearchCriteria searchCriteria, @Nonnull PageRequest pageRequest) {
        Page<StashUser> page = this.searchUsers(searchCriteria, pageRequest, false);
        if (page.getIsLastPage() && page.getSize() == 0) {
            return PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        }
        Query query = this.session().createQuery("select p.user.id, max(w.weight) from InternalGrantedPermission p, InternalWeightedPermission w where p.permission = w.id and p.user.id in (:userIds) " + this.calcProjectClause((PermissionSearchCriteria)searchCriteria) + "group by p.user.id");
        if (searchCriteria.hasProjectId()) {
            query.setParameter("projectId", (Object)searchCriteria.getProjectId());
        }
        query.setParameterList("userIds", (Collection)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)page.getValues(), (Function)new Function<StashUser, Integer>(){

            public Integer apply(StashUser user) {
                return user.getId();
            }
        })));
        List values = query.list();
        final HashMap<Integer, Integer> idToWeight = new HashMap<Integer, Integer>(values.size());
        for (Object[] objects : values) {
            idToWeight.put((Integer)objects[0], (Integer)objects[1]);
        }
        ImmutableList users = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)page.getValues(), (Function)new Function<StashUser, PermittedUser>(){

            public InternalPermittedUser apply(StashUser user) {
                Integer weight = (Integer)idToWeight.get(user.getId());
                if (weight == null) {
                    throw new IllegalStateException("No weight was found for the permission assigned to " + user.getName());
                }
                return new InternalPermittedUser(user, weight.intValue());
            }
        }));
        return new PageImpl(pageRequest, page.getSize(), (Iterable)users, page.getIsLastPage());
    }

    private String calcProjectClause(PermissionSearchCriteria searchCriteria) {
        if (searchCriteria.hasProjectId()) {
            return "and p.project.id = :projectId ";
        }
        if (searchCriteria.getFilterMode() == PermissionFilterMode.ONLY_RESOURCE) {
            return "and p.project is not null ";
        }
        if (searchCriteria.getFilterMode() == PermissionFilterMode.ONLY_GLOBAL) {
            return "and p.project is null ";
        }
        return "";
    }

    public boolean hasPermissionEntry(@Nonnull Permission permission, @Nullable Project project, @Nullable String group, @Nullable StashUser user) {
        Criteria criteria = this.session().createCriteria(InternalGrantedPermission.class).add((Criterion)Restrictions.eq((String)"permission", (Object)permission)).add((Criterion)(project == null ? Restrictions.isNull((String)"project") : Restrictions.eq((String)"project", (Object)project))).add((Criterion)(group == null ? Restrictions.isNull((String)"group") : Restrictions.eq((String)"group", (Object)IdentifierUtils.toLowerCase((String)group)))).add((Criterion)(user == null ? Restrictions.isNull((String)"user") : Restrictions.eq((String)"user", (Object)user))).setProjection((Projection)Projections.count((String)"id"));
        return (Long)criteria.uniqueResult() > 0L;
    }

    public boolean hasPermissionEntry(@Nonnull InternalGrantedPermission grantedPermission) {
        return this.hasPermissionEntry(grantedPermission.getPermission(), (Project)grantedPermission.getProject(), grantedPermission.getGroup(), (StashUser)grantedPermission.getUser());
    }

    public boolean isGrantedToGroup(@Nonnull GroupPermissionSearchCriteria searchCriteria) {
        DetachedCriteria permissionCriteria = this.createPermissionCriteria((PermissionSearchCriteria)searchCriteria, true).add(Restrictions.isNull((String)"user")).setProjection((Projection)Projections.count((String)"id"));
        if (searchCriteria.hasGroups()) {
            permissionCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"group"), (Criterion)Restrictions.in((String)"group", (Collection)Collections2.transform((Collection)searchCriteria.getGroups(), TO_LOWERCASE))));
        } else if (searchCriteria.hasName()) {
            permissionCriteria.add(Restrictions.ilike((String)"group", (String)searchCriteria.getName(), (MatchMode)MatchMode.ANYWHERE));
        } else {
            permissionCriteria.add(Restrictions.isNotNull((String)"group"));
        }
        Criteria criteria = permissionCriteria.getExecutableCriteria(this.session()).setCacheable(true).setCacheRegion("query.permissions");
        return (Long)criteria.uniqueResult() > 0L;
    }

    public boolean isGrantedToUser(@Nonnull UserPermissionSearchCriteria searchCriteria) {
        Criteria criteria;
        DetachedCriteria permissionCriteria = this.createPermissionCriteria((PermissionSearchCriteria)searchCriteria, true).add(Restrictions.isNull((String)"group"));
        if (searchCriteria.hasUser()) {
            permissionCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"user"), (Criterion)Restrictions.eq((String)"user.id", (Object)searchCriteria.getUser())));
        } else {
            permissionCriteria.add(Restrictions.isNotNull((String)"user"));
        }
        if (searchCriteria.hasName()) {
            permissionCriteria.setProjection(Projections.distinct((Projection)Projections.property((String)"user.id")));
            criteria = this.session().createCriteria(InternalStashUser.class).add((Criterion)Restrictions.like((String)"username", (String)searchCriteria.getName(), (MatchMode)MatchMode.ANYWHERE)).add(Subqueries.propertyIn((String)"id", (DetachedCriteria)permissionCriteria));
        } else {
            criteria = permissionCriteria.getExecutableCriteria(this.session());
        }
        criteria.setProjection((Projection)Projections.count((String)"id"));
        return (Long)criteria.uniqueResult() > 0L;
    }

    public Page<String> searchGroups(@Nonnull GroupPermissionSearchCriteria searchCriteria, @Nonnull PageRequest pageRequest) {
        return this.searchGroups(searchCriteria, pageRequest, true);
    }

    public Page<StashUser> searchUsers(@Nonnull UserPermissionSearchCriteria searchCriteria, @Nonnull PageRequest pageRequest) {
        return this.searchUsers(searchCriteria, pageRequest, true);
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"id");
    }

    private DetachedCriteria createPermissionCriteria(PermissionSearchCriteria searchCriteria, boolean includeImplicit) {
        boolean allowResource;
        DetachedCriteria criteria = DetachedCriteria.forClass(InternalGrantedPermission.class);
        if (searchCriteria.getFilterMode() == PermissionFilterMode.ONLY_GLOBAL) {
            criteria.add(Restrictions.in((String)"permission", (Collection)Permission.getGlobalPermissions()));
            allowResource = false;
        } else if (searchCriteria.getFilterMode() == PermissionFilterMode.ONLY_RESOURCE) {
            criteria.add(Restrictions.in((String)"permission", (Collection)Permission.getResourcePermissions()));
            allowResource = true;
        } else if (searchCriteria.hasPermission()) {
            Permission permission = searchCriteria.getPermission();
            allowResource = permission.isResource();
            if (searchCriteria.getFilterMode() == PermissionFilterMode.INHERITING) {
                criteria.add(Restrictions.in((String)"permission", (Collection)permission.getInheritingPermissions()));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)"permission", (Object)permission));
            }
        } else {
            allowResource = true;
        }
        if (allowResource) {
            if (searchCriteria.hasProjectId()) {
                SimpleExpression project = Restrictions.eq((String)"project.id", (Object)searchCriteria.getProjectId());
                if (includeImplicit) {
                    project = Restrictions.or((Criterion)Restrictions.isNull((String)"project"), (Criterion)project);
                }
                criteria.add((Criterion)project);
            }
        } else {
            criteria.add(Restrictions.isNull((String)"project"));
        }
        return criteria;
    }

    private Page<String> searchGroups(GroupPermissionSearchCriteria searchCriteria, PageRequest pageRequest, boolean includeImplicit) {
        DetachedCriteria permissionCriteria = this.createPermissionCriteria((PermissionSearchCriteria)searchCriteria, includeImplicit).add(Restrictions.isNull((String)"user")).addOrder(Order.asc((String)"group")).setProjection(Projections.distinct((Projection)Projections.property((String)"group")));
        if (searchCriteria.hasGroups()) {
            permissionCriteria.add(Restrictions.in((String)"group", (Collection)Collections2.transform((Collection)searchCriteria.getGroups(), TO_LOWERCASE)));
        } else if (searchCriteria.hasName()) {
            permissionCriteria.add(Restrictions.ilike((String)"group", (String)IdentifierUtils.toLowerCase((String)searchCriteria.getName()), (MatchMode)MatchMode.ANYWHERE));
        } else {
            permissionCriteria.add(Restrictions.isNotNull((String)"group"));
        }
        Criteria criteria = permissionCriteria.getExecutableCriteria(this.session()).setCacheable(true).setCacheRegion("query.permissions");
        return this.pageCriteria(criteria, pageRequest);
    }

    private Page<StashUser> searchUsers(UserPermissionSearchCriteria searchCriteria, PageRequest pageRequest, boolean includeImplicit) {
        DetachedCriteria permissionCriteria = this.createPermissionCriteria((PermissionSearchCriteria)searchCriteria, includeImplicit).add(Restrictions.isNull((String)"group")).setProjection(Projections.distinct((Projection)Projections.property((String)"user.id")));
        if (searchCriteria.hasUser()) {
            permissionCriteria.add((Criterion)Restrictions.eq((String)"user.id", (Object)searchCriteria.getUser()));
        } else {
            permissionCriteria.add(Restrictions.isNotNull((String)"user"));
        }
        Criteria criteria = this.session().createCriteria(InternalStashUser.class);
        criteria.add(Subqueries.propertyIn((String)"id", (DetachedCriteria)permissionCriteria)).addOrder(Order.asc((String)"username"));
        if (searchCriteria.hasName()) {
            criteria.add((Criterion)Restrictions.like((String)"username", (String)searchCriteria.getName(), (MatchMode)MatchMode.ANYWHERE));
        }
        return this.pageCriteria(criteria, pageRequest);
    }
}

