/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.AbstractDaoImpl;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Locale;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryDao")
public class RepositoryDaoImpl
extends AbstractDaoImpl<Integer, InternalRepository>
implements RepositoryDao {
    @Autowired
    public RepositoryDaoImpl(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public int countByProject(int projectId) {
        return ((Long)this.session().createQuery("SELECT count(*) from InternalRepository WHERE project.id = :projectId").setParameter("projectId", (Object)projectId).uniqueResult()).intValue();
    }

    public InternalRepository findByNameAndProjectKey(String repoName, String projectKey) {
        Query query = this.session().createQuery("from InternalRepository where upper(name) = upper(:repoName) and upper(project.key) = upper(:projectKey)");
        query.setParameter("repoName", (Object)repoName);
        query.setParameter("projectKey", (Object)projectKey);
        return (InternalRepository)query.uniqueResult();
    }

    public List<InternalRepository> findByOrigin(InternalRepository origin) {
        Query query = this.session().createQuery("from InternalRepository where origin = :origin");
        query.setParameter("origin", (Object)origin);
        return query.list();
    }

    public Page<InternalRepository> findByProjectKey(String projectKey, PageRequest pageRequest, Predicate<? super InternalRepository> predicate) {
        Query query = this.session().createQuery("from InternalRepository where upper(project.key) = upper(:projectKey) order by upper(name)");
        query.setParameter("projectKey", (Object)projectKey);
        return this.pageQuery(query, pageRequest, predicate);
    }

    public InternalRepository findBySlugAndProjectKey(String slug, String projectKey) {
        Query query = this.session().createQuery("from InternalRepository  where slug = :slug and upper(project.key) = upper(:projectKey)").setParameter("slug", (Object)slug.toLowerCase(Locale.US)).setParameter("projectKey", (Object)projectKey);
        return (InternalRepository)query.uniqueResult();
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"name").ignoreCase();
    }
}

