/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.stash.internal.AbstractDaoImpl;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.ProjectDao;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.project.Project;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="projectDao")
public class ProjectDaoImpl
extends AbstractDaoImpl<Integer, InternalProject>
implements ProjectDao {
    @Autowired
    public ProjectDaoImpl(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"name").ignoreCase();
    }

    public InternalProject findByKey(String projectKey) {
        Query query = this.session().createQuery("from InternalProject where upper(key) = upper(:projectKey)");
        query.setParameter("projectKey", (Object)projectKey);
        query.setCacheable(true);
        query.setCacheRegion("query.projects");
        return (InternalProject)query.uniqueResult();
    }

    public Iterable<String> findAllKeys(@Nonnull Predicate<? super Project> predicate) {
        Query query = this.session().createQuery("select new com.atlassian.stash.internal.project.ProjectIdKeyWrapper(p.id, p.key) from InternalProject p order by p.key");
        return Iterables.transform((Iterable)Iterables.filter((Iterable)query.list(), predicate), (Function)new Function<Project, String>(){

            public String apply(Project project) {
                Preconditions.checkNotNull((Object)project);
                return project.getKey();
            }
        });
    }

    public InternalProject findByName(String name) {
        Query query = this.session().createQuery("from InternalProject where upper(name) = upper(:name)");
        query.setParameter("name", (Object)name);
        return (InternalProject)query.uniqueResult();
    }

    public boolean hasRepositories(int projectId) {
        Criteria criteria = this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"project.id", (Object)projectId)).setMaxResults(1).setProjection(Projections.rowCount());
        return (Long)criteria.uniqueResult() != 0L;
    }
}

