/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.type.NullableType;
import org.hibernate.type.TypeFactory;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.ParameterizedType;

public class GenericEnumUserType
implements EnhancedUserType,
ParameterizedType {
    private static final String DEFAULT_IDENTIFIER_METHOD_NAME = "getId";
    private static final String DEFAULT_VALUE_OF_METHOD_NAME = "fromId";
    private static final Class[] NULL_CLASS_VARARG = null;
    private static final Object[] NULL_OBJECT_VARARG = null;
    private static final char SINGLE_QUOTE = '\'';
    private Class<? extends Enum> enumClass;
    private Method identifierMethod;
    private int[] sqlTypes;
    private NullableType type;
    private Method valueOfMethod;

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    public Object fromXMLString(String xmlValue) {
        return Enum.valueOf(this.enumClass, xmlValue);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Object identifier = this.type.get(rs, names[0]);
        if (identifier == null || rs.wasNull()) {
            return null;
        }
        try {
            return this.valueOfMethod.invoke(this.enumClass, identifier);
        }
        catch (Exception exception) {
            String msg = "Exception while invoking valueOfMethod [" + this.valueOfMethod.getName() + "] of Enum class [" + this.enumClass.getName() + "] with argument of type [" + identifier.getClass().getName() + "], value=[" + identifier + "]";
            throw new HibernateException(msg, (Throwable)exception);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, this.sqlTypes[0]);
        } else {
            try {
                Object identifier = this.identifierMethod.invoke(value, NULL_OBJECT_VARARG);
                this.type.set(st, identifier, index);
            }
            catch (Exception exception) {
                String msg = "Exception while invoking identifierMethod [" + this.identifierMethod.getName() + "] of Enum class [" + this.enumClass.getName() + "] with argument of type [" + value.getClass().getName() + "], value=[" + value + "]";
                throw new HibernateException(msg, (Throwable)exception);
            }
        }
    }

    public String objectToSQLString(Object value) {
        return '\'' + ((Enum)value).name() + '\'';
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Class returnedClass() {
        return this.enumClass;
    }

    public void setParameterValues(Properties parameters) {
        Class<?> identifierType;
        String enumClassName = parameters.getProperty("enumClass");
        try {
            this.enumClass = Class.forName(enumClassName).asSubclass(Enum.class);
        }
        catch (ClassNotFoundException exception) {
            throw new HibernateException("Enum class not found", (Throwable)exception);
        }
        String identifierMethodName = parameters.getProperty("identifierMethod", DEFAULT_IDENTIFIER_METHOD_NAME);
        try {
            this.identifierMethod = this.enumClass.getMethod(identifierMethodName, NULL_CLASS_VARARG);
            identifierType = this.identifierMethod.getReturnType();
        }
        catch (Exception exception) {
            throw new HibernateException("Failed to obtain identifier method", (Throwable)exception);
        }
        this.type = (NullableType)TypeFactory.basic((String)identifierType.getName());
        if (this.type == null) {
            throw new HibernateException("Unsupported identifier type " + identifierType.getName());
        }
        this.sqlTypes = new int[]{this.type.sqlType()};
        String valueOfMethodName = parameters.getProperty("valueOfMethod", DEFAULT_VALUE_OF_METHOD_NAME);
        try {
            this.valueOfMethod = this.enumClass.getMethod(valueOfMethodName, identifierType);
        }
        catch (Exception exception) {
            throw new HibernateException("Failed to obtain valueOf method", (Throwable)exception);
        }
    }

    public int[] sqlTypes() {
        return this.sqlTypes;
    }

    public String toXMLString(Object value) {
        return ((Enum)value).name();
    }
}

