/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.AbstractDaoImpl;
import com.atlassian.stash.internal.user.GrantedPermissionDao;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="grantedPermissionDao")
public class GrantedPermissionDaoImpl
extends AbstractDaoImpl<Integer, InternalGrantedPermission>
implements GrantedPermissionDao {
    @Autowired
    public GrantedPermissionDaoImpl(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public boolean isGrantedForAnonByProject(Set<Permission> permissions, Integer projectId) {
        Criteria criteria = this.session().createCriteria(InternalGrantedPermission.class).add(Restrictions.in((String)"permission", permissions)).add((Criterion)Restrictions.eq((String)"allowAnon", (Object)true)).setMaxResults(1);
        if (projectId != null) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"project.id", (Object)projectId), (Criterion)Restrictions.isNull((String)"project")));
        } else {
            criteria.add(Restrictions.isNull((String)"project"));
        }
        return criteria.uniqueResult() != null;
    }

    public boolean isGrantedByProjectAndUser(Set<Permission> permissions, Integer projectId, Integer userId) {
        Criteria criteria = this.session().createCriteria(InternalGrantedPermission.class).add(Restrictions.in((String)"permission", permissions));
        if (projectId == null || projectId != -1) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"project.id", (Object)projectId), (Criterion)Restrictions.isNull((String)"project")));
        }
        criteria.add(Restrictions.isNull((String)"group")).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"user.id", (Object)userId), (Criterion)Restrictions.isNull((String)"user"))).setMaxResults(1).setCacheable(true).setCacheRegion("query.permissions");
        return criteria.uniqueResult() != null;
    }

    public Page<StashUser> getGrantedUsers(Set<Permission> permissions, PageRequest request) {
        Preconditions.checkArgument((!permissions.isEmpty() ? 1 : 0) != 0);
        Criteria criteria = this.session().createCriteria(InternalGrantedPermission.class).add(Restrictions.in((String)"permission", permissions)).add(Restrictions.isNotNull((String)"user"));
        criteria.setFirstResult(request.getStart());
        criteria.setMaxResults(request.getLimit());
        List grantedPermissions = criteria.list();
        HashSet results = new HashSet(grantedPermissions.size());
        Iterables.addAll(results, (Iterable)Iterables.transform((Iterable)grantedPermissions, (Function)new Function<InternalGrantedPermission, StashUser>(){

            public StashUser apply(InternalGrantedPermission input) {
                return input.getUser();
            }
        }));
        return PageUtils.createPage(results, (PageRequest)request);
    }

    public Page<String> getGrantedGroups(Set<Permission> permissions, PageRequest request) {
        Preconditions.checkArgument((!permissions.isEmpty() ? 1 : 0) != 0);
        Criteria criteria = this.session().createCriteria(InternalGrantedPermission.class).add(Restrictions.in((String)"permission", permissions)).add(Restrictions.isNotNull((String)"group"));
        criteria.setFirstResult(request.getStart());
        criteria.setMaxResults(request.getLimit());
        List grantedPermissions = criteria.list();
        HashSet results = new HashSet(grantedPermissions.size());
        Iterables.addAll(results, (Iterable)Iterables.transform((Iterable)grantedPermissions, (Function)new Function<InternalGrantedPermission, String>(){

            public String apply(InternalGrantedPermission input) {
                return input.getGroup();
            }
        }));
        return PageUtils.createPage(results, (PageRequest)request);
    }

    public boolean isGrantedByUser(Set<Permission> permissions, Integer userId) {
        return this.isGrantedByProjectAndUser(permissions, -1, userId);
    }

    public boolean isGrantedByProjectAndGroup(Set<Permission> permissions, Integer projectId, String group) {
        Criteria criteria = this.session().createCriteria(InternalGrantedPermission.class).add(Restrictions.in((String)"permission", permissions)).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"project.id", (Object)projectId), (Criterion)Restrictions.isNull((String)"project"))).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"group", (Object)IdentifierUtils.toLowerCase((String)group)), (Criterion)Restrictions.isNull((String)"group"))).add(Restrictions.isNull((String)"user")).setCacheable(true).setCacheRegion("query.permissions").setMaxResults(1);
        return criteria.uniqueResult() != null;
    }

    public boolean hasPermissionEntry(@Nonnull Permission permission, @Nullable Project project, @Nullable String group, @Nullable StashUser user, boolean allowAnon) {
        Criteria criteria = this.session().createCriteria(InternalGrantedPermission.class).add((Criterion)Restrictions.eq((String)"permission", (Object)permission)).add((Criterion)(project == null ? Restrictions.isNull((String)"project") : Restrictions.eq((String)"project", (Object)project))).add((Criterion)(group == null ? Restrictions.isNull((String)"group") : Restrictions.eq((String)"group", (Object)IdentifierUtils.toLowerCase((String)group)))).add((Criterion)(user == null ? Restrictions.isNull((String)"user") : Restrictions.eq((String)"user", (Object)user))).add((Criterion)Restrictions.eq((String)"allowAnon", (Object)allowAnon)).setMaxResults(1);
        return criteria.uniqueResult() != null;
    }

    public boolean hasPermissionEntry(InternalGrantedPermission grantedPermission) {
        return this.hasPermissionEntry(grantedPermission.getPermission(), (Project)grantedPermission.getProject(), grantedPermission.getGroup(), (StashUser)grantedPermission.getUser(), grantedPermission.isAllowAnon());
    }

    public Page<String> getGrantedGroupsByPermissionAndProject(Set<Permission> permissions, Integer projectId, PageRequest pageRequest) {
        Query query = this.session().createQuery("SELECT distinct(perm.group) FROM InternalGrantedPermission perm WHERE perm.permission in (:permissions) " + (projectId == null || projectId != -1 ? "AND (" + (projectId != null ? "perm.project.id = :projectId OR " : "") + "perm.project is null) " : "") + "AND perm.group is not null " + "ORDER BY perm.group");
        query.setCacheable(true);
        query.setCacheRegion("query.permissions");
        query.setParameterList("permissions", permissions);
        if (projectId != null && projectId != -1) {
            query.setParameter("projectId", (Object)projectId);
        }
        return this.pageQuery(query, pageRequest);
    }

    public Page<String> getGrantedGroupsByPermission(Set<Permission> permissions, PageRequest pageRequest) {
        return this.getGrantedGroupsByPermissionAndProject(permissions, -1, pageRequest);
    }

    public Page<StashUser> getUsersWithPermission(@Nullable String usernamePattern, @Nonnull Permission permission, Project project, @Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("SELECT user FROM InternalGrantedPermission perm, InternalStashUser user WHERE perm.permission = :permission AND " + (project == null ? "perm.project is null " : "perm.project = :project ") + "AND perm.group is null " + "AND perm.user = user " + (usernamePattern != null ? "AND perm.user.username like :pattern " : "") + "ORDER BY user.username");
        return this.pagePatternedPermissionQuery(query, usernamePattern, permission, project, pageRequest);
    }

    public Page<String> getGroupsWithPermission(@Nullable String groupnamePattern, @Nonnull Permission permission, @Nullable Project project, @Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("SELECT perm.group FROM InternalGrantedPermission perm WHERE perm.permission = :permission AND " + (project == null ? "perm.project is null " : "perm.project = :project ") + (groupnamePattern != null ? "and perm.group like :pattern " : "") + "AND perm.user is null " + "AND perm.group is not null " + "ORDER BY perm.group");
        return this.pagePatternedPermissionQuery(query, groupnamePattern, permission, project, pageRequest);
    }

    private <T> Page<T> pagePatternedPermissionQuery(Query query, String pattern, Permission permission, Project project, PageRequest pageRequest) {
        query.setParameter("permission", (Object)permission);
        if (project != null) {
            query.setParameter("project", (Object)project);
        }
        if (pattern != null) {
            query.setParameter("pattern", (Object)("%" + IdentifierUtils.toLowerCase((String)pattern) + "%"));
        }
        return this.pageQuery(query, pageRequest);
    }

    public int deleteGrantedPermissions(@Nonnull Permission permission, Integer project, Integer user, String group, boolean allowAnon) {
        Query query = this.session().createQuery("delete InternalGrantedPermission perm where perm.permission = :permission and " + (project == null ? "perm.project is null " : "perm.project.id = :project ") + "and " + (user == null ? "perm.user is null " : "perm.user.id = :user ") + "and " + (group == null ? "perm.group is null " : "perm.group = :group ") + "and " + "perm.allowAnon = :allowAnon");
        query.setParameter("permission", (Object)permission);
        query.setParameter("allowAnon", (Object)allowAnon);
        if (project != null) {
            query.setParameter("project", (Object)project);
        }
        if (user != null) {
            query.setParameter("user", (Object)user);
        }
        if (group != null) {
            query.setParameter("group", (Object)IdentifierUtils.toLowerCase((String)group));
        }
        return query.executeUpdate();
    }

    public int deleteAllProjectPermissions(@Nonnull Integer projectId) {
        Query query = this.session().createQuery("delete InternalGrantedPermission perm where perm.project.id = :projectId");
        query.setParameter("projectId", (Object)projectId);
        return query.executeUpdate();
    }

    public int deleteAllUserPermissions(int userId) {
        Query query = this.session().createQuery("delete InternalGrantedPermission perm where perm.user.id = :userId");
        query.setParameter("userId", (Object)userId);
        return query.executeUpdate();
    }

    public int deleteAllGroupPermissions(String name) {
        Query query = this.session().createQuery("delete InternalGrantedPermission perm where perm.group = :group");
        query.setParameter("group", (Object)IdentifierUtils.toLowerCase((String)name));
        return query.executeUpdate();
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"id");
    }
}

