/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.stash.idx.ChangesetIndexer;
import com.atlassian.stash.internal.AbstractDaoImpl;
import com.atlassian.stash.internal.idx.ChangesetIndexerStateDao;
import com.atlassian.stash.internal.idx.InternalChangesetIndexerState;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Repository
public class ChangesetIndexerStateDaoImpl
extends AbstractDaoImpl<InternalChangesetIndexerState.PK, InternalChangesetIndexerState>
implements ChangesetIndexerStateDao {
    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"indexerId");
    }

    @Autowired
    public ChangesetIndexerStateDaoImpl(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    private Set<String> extractIds(Iterable<ChangesetIndexer> indexers) {
        HashSet indexerIds = Sets.newHashSet();
        for (ChangesetIndexer indexer : indexers) {
            indexerIds.add(indexer.getId());
        }
        return indexerIds;
    }

    public Date getOldestLastRunDate(Repository repository, Iterable<ChangesetIndexer> indexers) {
        Set<String> indexerIds = this.extractIds(indexers);
        if (!indexerIds.isEmpty()) {
            Query query = this.session().createQuery("select min(lastRun) from InternalChangesetIndexerState WHERE indexerId in (:ids) AND repository.id = :repo_id").setParameterList("ids", indexerIds).setParameter("repo_id", (Object)repository.getId());
            return this.getDate((Long)query.uniqueResult());
        }
        return null;
    }

    public Date getLastRunDate(Repository repository, ChangesetIndexer indexer) {
        InternalChangesetIndexerState state;
        if (indexer != null && indexer.getId() != null && (state = (InternalChangesetIndexerState)this.getById(new InternalChangesetIndexerState.PK(indexer.getId(), repository.getId().intValue()))) != null) {
            return this.getDate(state.getLastRun());
        }
        return null;
    }

    private Long getTime(Date date) {
        return date != null ? Long.valueOf(date.getTime()) : null;
    }

    private Date getDate(Long time) {
        return time != null ? new Date(time) : null;
    }

    public void setLastRunDate(Repository repository, ChangesetIndexer indexer, Date date) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)indexer);
        Preconditions.checkNotNull((Object)indexer.getId());
        Preconditions.checkNotNull((Object)date);
        InternalChangesetIndexerState state = new InternalChangesetIndexerState(indexer.getId(), (InternalRepository)repository, this.getTime(date));
        this.update(state);
    }

    public void setLastRunDate(Repository repository, Iterable<ChangesetIndexer> indexers, Date date) {
        for (ChangesetIndexer indexer : indexers) {
            this.setLastRunDate(repository, indexer, date);
        }
    }
}

