/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.repository.RepositoryOrder;
import com.atlassian.stash.repository.RepositoryVisibility;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class RepositorySearchCriteria {
    private String name;
    private String projectName;
    private RepositoryOrder order = RepositoryOrder.DEFAULT;
    private RepositoryVisibility visibility;

    @Nonnull
    public RepositoryOrder getOrder() {
        return this.order;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getProjectName() {
        return this.projectName;
    }

    @Nullable
    public RepositoryVisibility getVisibility() {
        return this.visibility;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasProjectName() {
        return this.projectName != null;
    }

    public boolean hasVisibility() {
        return this.visibility != null;
    }

    @Nonnull
    public RepositorySearchCriteria setName(@Nullable String name) {
        this.name = StringUtils.trimToNull((String)name);
        return this;
    }

    @Nonnull
    public RepositorySearchCriteria setProjectName(@Nullable String projectName) {
        this.projectName = projectName;
        return this;
    }

    @Nonnull
    public RepositorySearchCriteria setOrder(@Nonnull RepositoryOrder order) {
        this.order = (RepositoryOrder)((Object)Preconditions.checkNotNull((Object)((Object)order), (Object)"order"));
        return this;
    }

    public RepositorySearchCriteria setVisibility(@Nullable RepositoryVisibility visibility) {
        this.visibility = visibility;
        return this;
    }
}

