/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.atlassian.fugue.Effect;
import com.atlassian.stash.Product;
import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.db.SimpleDataSourceConfiguration;
import com.atlassian.stash.internal.hibernate.DataSourceConfiguration;
import com.atlassian.stash.internal.hibernate.MutableDataSourceConfiguration;
import com.atlassian.stash.internal.hibernate.UnsupportedJdbcUrlException;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSourceConfiguration
implements MutableDataSourceConfiguration {
    public static final String JTDS_DRIVER = "net.sourceforge.jtds.jdbc.Driver";
    public static final String JTDS_PROTOCOL = "jdbc:jtds:sqlserver";
    public static final Pattern JTDS_URL = Pattern.compile("jdbc:jtds:sqlserver://([^:;/]++)(?::([\\d]{1,5}))?(?:/([^;]++))?(?:$|([^:/].*))");
    private static final Logger log = LoggerFactory.getLogger(DefaultDataSourceConfiguration.class);
    private long connectTimeout;
    private String driverClassName;
    private String password;
    private String url;
    private String user;

    public DefaultDataSourceConfiguration(String driverClassName, String user, String password, String url) {
        this.update(driverClassName, url, user, password);
    }

    @Override
    @Nonnull
    public DataSourceConfiguration copy() {
        return new SimpleDataSourceConfiguration(this.driverClassName, this.url, this.user, this.password);
    }

    @Override
    @Nonnull
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Override
    @Nonnull
    public String getPassword() {
        return this.password;
    }

    @Override
    public Properties getProperties() {
        final Properties properties = new Properties();
        DefaultDataSourceConfiguration.putIfNotBlank(properties, "user", this.getUser());
        DefaultDataSourceConfiguration.putIfNotBlank(properties, "password", this.getPassword());
        if (this.connectTimeout > 0L) {
            DbType.forDriver(this.getDriverClassName()).foreach((Effect)new Effect<DbType>(){

                public void apply(DbType dbType) {
                    properties.putAll(dbType.getPropertyMap(Duration.standardSeconds((long)DefaultDataSourceConfiguration.this.connectTimeout)));
                }
            });
        }
        return properties;
    }

    @Override
    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nonnull
    public String getUser() {
        return this.user;
    }

    @Override
    public boolean isPasswordSet() {
        return StringUtils.isNotEmpty((String)this.password);
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    @Nonnull
    public DataSourceConfiguration update(DataSourceConfiguration configuration) {
        DataSourceConfiguration old = this.copy();
        this.update(configuration.getDriverClassName(), configuration.getUrl(), configuration.getUser(), configuration.getPassword());
        return old;
    }

    public String toString() {
        return this.user + "@" + this.url + " via " + this.driverClassName;
    }

    private void update(String driverClassName, String url, String user, String password) {
        if (JTDS_DRIVER.equals(driverClassName)) {
            log.debug("Replacing jTDS JDBC details with Microsoft equivalents. Original values: Driver = [{}], URL = [{}]", (Object)driverClassName, (Object)url);
            url = DefaultDataSourceConfiguration.rewriteUrl(url);
            driverClassName = DbType.MSSQL.getDriverClassName();
            log.warn("Replaced jTDS JDBC details with Microsoft equivalents. New values: Driver = [{}], URL = [{}]", (Object)driverClassName, (Object)url);
        }
        this.driverClassName = driverClassName;
        this.user = user;
        this.password = password;
        this.url = url;
    }

    private static Map<String, String> parseParameters(String value) {
        if (StringUtils.isBlank((String)value)) {
            return Maps.newHashMap();
        }
        String[] pieces = value.split(";");
        HashMap<String, String> parameters = new HashMap<String, String>(pieces.length);
        for (String piece : pieces) {
            if (StringUtils.isBlank((String)piece)) continue;
            String[] keyValue = piece.split("=");
            parameters.put(keyValue[0], keyValue[1]);
        }
        return parameters;
    }

    private static int parsePort(String value) {
        int port = value == null ? (Integer)DbType.MSSQL.getDefaultPort().get() : Integer.parseInt(value);
        return port;
    }

    private static void putIfNotBlank(Properties properties, String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            properties.put(key, value);
        }
    }

    private static String rewriteUrl(String url) {
        Matcher matcher = JTDS_URL.matcher(url);
        if (matcher.matches()) {
            Map<String, String> parameters = DefaultDataSourceConfiguration.parseParameters(matcher.group(4));
            String databaseName = matcher.group(3);
            if (databaseName == null) {
                databaseName = parameters.remove("databaseName");
            }
            if (databaseName != null && parameters.isEmpty()) {
                int port = DefaultDataSourceConfiguration.parsePort(matcher.group(2));
                return DbType.MSSQL.generateUrl(matcher.group(1), databaseName, port);
            }
        }
        log.error("JDBC URL {} was not generated by {} and cannot be updated automatically", (Object)url, (Object)Product.NAME);
        throw new UnsupportedJdbcUrlException("The configured JDBC URL is no longer supported");
    }
}

