/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring;

import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.DelegatingTransactionDefinition;

public class SpringTransactionUtils {
    public static final TransactionDefinition REQUIRES_NEW = SpringTransactionUtils.constantFor(3);

    public static TransactionDefinition definitionFor(int propagationBehavior) {
        return SpringTransactionUtils.definitionFor(propagationBehavior, false);
    }

    public static TransactionDefinition definitionFor(int propagationBehavior, boolean readOnly) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(propagationBehavior);
        definition.setReadOnly(readOnly);
        return definition;
    }

    private static TransactionDefinition constantFor(int propagationBehavior) {
        return new UnmodifiableTransactionDefinition(SpringTransactionUtils.definitionFor(propagationBehavior));
    }

    private static final class UnmodifiableTransactionDefinition
    extends DelegatingTransactionDefinition {
        private UnmodifiableTransactionDefinition(TransactionDefinition targetDefinition) {
            super(targetDefinition);
        }
    }
}

