/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.PermissionCriteria;
import com.atlassian.stash.user.Permission;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;

public class GroupPermissionCriteria
extends PermissionCriteria {
    private final Set<String> groups;

    private GroupPermissionCriteria(Iterable<String> groups, Permission permission, Integer projectId, Integer repositoryId) {
        super(permission, projectId, repositoryId);
        Preconditions.checkArgument((groups != null && !Iterables.isEmpty(groups) ? 1 : 0) != 0, (Object)"at least a group must be specified");
        Preconditions.checkArgument((boolean)Iterables.all(groups, (Predicate)Predicates.notNull()), (Object)"null groups are not accepted");
        this.groups = ImmutableSet.copyOf(groups);
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public static class Builder
    extends PermissionCriteria.AbstractBuilder<Builder> {
        private final Iterable<String> groups;

        public Builder(String group) {
            this.groups = Collections.singleton(group);
        }

        public Builder(Iterable<String> groups) {
            this.groups = groups;
        }

        public GroupPermissionCriteria build() {
            return new GroupPermissionCriteria(this.groups, this.permission, this.projectId, this.repositoryId);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

