/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.fugue.Option;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.joda.time.Duration;
import org.springframework.jdbc.datasource.AbstractDriverBasedDataSource;
import org.springframework.util.ClassUtils;

public enum DbType {
    MSSQL("mssql", "com.atlassian.stash.database.display.name.mssql", "jdbc:sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", false, Option.some((Object)1433)){

        @Override
        @Nonnull
        public String generateUrl(@Nonnull String hostName, @Nonnull String database, int port) {
            return String.format("%1$s://%2$s:%3$d;databaseName=%4$s;", this.getProtocol(), hostName, port, database);
        }
    }
    ,
    MYSQL("mysql", "com.atlassian.stash.database.display.name.mysql", "jdbc:mysql", "com.mysql.jdbc.Driver", false, Option.some((Object)3306)){

        @Override
        @Nonnull
        public String generateUrl(@Nonnull String hostName, @Nonnull String database, int port) {
            return String.format("%1$s://%2$s:%3$d/%4$s?autoReconnect=true&characterEncoding=utf8&useUnicode=true&sessionVariables=storage_engine%%3DInnoDB", this.getProtocol(), hostName, port, database);
        }

        @Override
        @Nonnull
        public Map<String, String> getPropertyMap(Duration timeout) {
            return ImmutableMap.of((Object)"connectTimeout", (Object)String.valueOf(timeout.getMillis()));
        }
    }
    ,
    ORACLE("oracle", "com.atlassian.stash.database.display.name.oracle", "jdbc:oracle:thin", "oracle.jdbc.driver.OracleDriver", true, Option.some((Object)1521)){

        @Override
        @Nonnull
        public String generateUrl(@Nonnull String hostName, @Nonnull String service, int port) {
            return String.format("%1$s:@//%2$s:%3$d/%4$s", this.getProtocol(), hostName, port, service);
        }

        @Override
        @Nonnull
        public Map<String, String> getPropertyMap(Duration timeout) {
            return ImmutableMap.of((Object)"oracle.net.CONNECT_TIMEOUT", (Object)String.valueOf(timeout.getMillis()));
        }
    }
    ,
    POSTGRES("postgres", "com.atlassian.stash.database.display.name.postgres", "jdbc:postgresql", "org.postgresql.Driver", false, Option.some((Object)5432)){

        @Override
        @Nonnull
        public String generateUrl(@Nonnull String hostName, @Nonnull String database, int port) {
            return String.format("%1$s://%2$s:%3$d/%4$s", this.getProtocol(), hostName, port, database);
        }
    };

    private static final String STASH_DB_MIGRATION_HELP_KEY = "stash.help.db.migration.";
    public static final List<DbType> AS_LIST;
    private static final Map<String, DbType> keyToEnum;
    private static final Map<String, DbType> driverToEnum;
    private final Option<String> defaultDatabaseName;
    private final Option<String> defaultHostName;
    private final Option<Integer> defaultPort;
    private final Option<String> defaultUserName;
    private final String displayNameKey;
    private final String driverClassName;
    private final String key;
    private final String protocol;
    private final boolean usesSid;

    @Nonnull
    public static Option<DbType> forKey(@Nonnull String key) {
        Preconditions.checkNotNull((Object)key);
        return Option.option((Object)((Object)keyToEnum.get(key)));
    }

    @Nonnull
    public static Option<DbType> forDriver(@Nonnull String driverClassName) {
        Preconditions.checkNotNull((Object)driverClassName);
        return Option.option((Object)((Object)driverToEnum.get(driverClassName)));
    }

    private static ImmutableMap<String, DbType> buildKeyToEnum() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DbType t : DbType.values()) {
            builder.put((Object)t.getKey(), (Object)t);
        }
        return builder.build();
    }

    private static ImmutableMap<String, DbType> buildDriverToEnum() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DbType t : DbType.values()) {
            builder.put((Object)t.getDriverClassName(), (Object)t);
        }
        return builder.build();
    }

    private DbType(String key, String displayNameKey, String protocol, String driverClassName, boolean usesSid, Option<Integer> defaultPort) {
        this(key, displayNameKey, protocol, driverClassName, usesSid, (Option<String>)Option.none(), (Option<String>)Option.none(), defaultPort, (Option<String>)Option.none());
    }

    private DbType(String key, String displayNameKey, String protocol, String driverClassName, boolean usesSid, Option<String> defaultDatabaseName, Option<String> defaultHostHame, Option<Integer> defaultPort, Option<String> defaultUserName) {
        this.defaultDatabaseName = defaultDatabaseName;
        this.defaultHostName = defaultHostHame;
        this.defaultPort = defaultPort;
        this.defaultUserName = defaultUserName;
        this.displayNameKey = displayNameKey;
        this.driverClassName = driverClassName;
        this.key = key;
        this.protocol = protocol;
        this.usesSid = usesSid;
    }

    public void applyTimeout(AbstractDriverBasedDataSource dataSource, Duration timeout) {
        this.setDataSourceProperties(this.getPropertyMap(timeout), dataSource);
    }

    @Nonnull
    public abstract String generateUrl(@Nonnull String var1, @Nonnull String var2, int var3);

    @Nonnull
    public Option<String> getDefaultDatabaseName() {
        return this.defaultDatabaseName;
    }

    @Nonnull
    public Option<String> getDefaultHostName() {
        return this.defaultHostName;
    }

    @Nonnull
    public Option<Integer> getDefaultPort() {
        return this.defaultPort;
    }

    @Nonnull
    public Option<String> getDefaultUserName() {
        return this.defaultUserName;
    }

    @Nonnull
    public String getDisplayNameKey() {
        return this.displayNameKey;
    }

    @Nonnull
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getHelpKey() {
        return STASH_DB_MIGRATION_HELP_KEY + this.getKey();
    }

    @Nonnull
    public Map<String, String> getPropertyMap(Duration timeout) {
        return ImmutableMap.of((Object)"loginTimeout", (Object)String.valueOf(timeout.getStandardSeconds()));
    }

    @Nonnull
    public String getProtocol() {
        return this.protocol;
    }

    public boolean isDriverAvailable() {
        return ClassUtils.isPresent((String)this.driverClassName, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    public boolean usesSid() {
        return this.usesSid;
    }

    private void setDataSourceProperties(Map<String, String> pairs, AbstractDriverBasedDataSource dataSource) {
        Properties connectionProperties = dataSource.getConnectionProperties();
        if (connectionProperties == null) {
            connectionProperties = new Properties();
        }
        connectionProperties.putAll(pairs);
        dataSource.setConnectionProperties(connectionProperties);
    }

    static {
        AS_LIST = ImmutableList.copyOf((Object[])DbType.values());
        keyToEnum = DbType.buildKeyToEnum();
        driverToEnum = DbType.buildDriverToEnum();
    }
}

