/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.PermissionFilterMode;
import com.atlassian.stash.user.Permission;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class PermissionSearchCriteria {
    public static final int NO_ID = -1;
    private PermissionFilterMode filterMode;
    private Permission permission;
    private int projectId = -1;

    @Nullable
    public PermissionFilterMode getFilterMode() {
        return this.filterMode;
    }

    @Nullable
    public Permission getPermission() {
        return this.permission;
    }

    public int getProjectId() {
        return this.hasProjectId() ? this.projectId : -1;
    }

    public boolean hasPermission() {
        return this.permission != null;
    }

    public boolean hasProjectId() {
        return (this.permission == null || this.permission.isResource()) && this.filterMode != PermissionFilterMode.ONLY_GLOBAL && this.projectId > -1;
    }

    public void setFilterMode(@Nullable PermissionFilterMode filterMode) {
        if (filterMode == null) {
            if (this.permission != null) {
                filterMode = PermissionFilterMode.INHERITING;
            }
        } else if (filterMode.isGroup()) {
            this.permission = null;
        }
        this.filterMode = filterMode;
    }

    public void setPermission(@Nullable Permission permission) {
        if (this.filterMode == null || this.filterMode.isGroup()) {
            this.filterMode = PermissionFilterMode.INHERITING;
        }
        this.permission = permission;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }
}

