define('branch-model/page/settings', [
    'jquery',
    'lodash',
    'stash/api/util/events',
    'stash/api/util/navbuilder',
    'util/ajax',
    'exports'
], function(
    $,
    _,
    eventsApi,
    nav,
    ajax,
    exports
) {

    var AUTOMERGE_DEFAULT = false;

    function getBranchModelForm() {
        return $('.branch-model-settings-form');
    }

    function isOn() {
        return getBranchModelForm().length === 1;
    }

    function isOff() {
        return !isOn();
    }

    function branchModelRestUrl() {
        return nav.rest('branch-utils').currentRepo().addPathComponents('branchmodel', 'configuration').build();
    }

    function toggleBranchModelEnabled(enabled) {
        enabled = _.isBoolean(enabled) ? enabled : isOff();
        ajax.rest({
            url: branchModelRestUrl(),
            // DELETE to disable branch model, PUT to enable it
            type: enabled ? 'PUT' : 'DELETE'
        }).done(function() {
            window.location.reload();
        });
    }

    function initTogglePrefixInputs() {
        var $form = getBranchModelForm();
        $form.on('change', '.branch-type-field-toggle', function(event) {
            var checkbox = $(event.target);
            var isEnabled = checkbox.prop('checked');
            checkbox.siblings(':text').prop('disabled', !isEnabled);
        });
    }

    function initToggleModelEnabled() {
        $('#branch-model-toggle').on('click', '.aui-button', function(e) {
            e.preventDefault();
            var promise = null;
            var $button = $(e.target);
            if ($button.hasClass('switch-mode-off') && isOn()) {
                toggleBranchModelEnabled(false);
            } else if ($button.hasClass('switch-mode-on') && isOff()) {
                toggleBranchModelEnabled(true);
            }
        });
    }

    function initWelcomeMatButton() {
        $('#welcome-mat-branch-model-enable').on('click', function() {
            toggleBranchModelEnabled(true);
        });
    }

    function initResetButton(defaultBranchModel) {
        var $form = getBranchModelForm();
        $('#branch-model-reset').click(function(e) {
            e.preventDefault();
            _.each(defaultBranchModel.types, function(type) {
                var $enabledInput = $form.find('#' + type.id + '-enabled');
                $enabledInput.prop('checked', type.enabled).trigger('change');
                var $prefixInput = $form.find('#' + type.id + '-prefix');
                $prefixInput.val(type.prefix);
            });
            $('.significant-branches').html(stash.page.branchmodel.significantBranchFields({
                branchModel: defaultBranchModel
            }));
            setAutoMergeDisabled(true);
        });
    }

    function setAutoMergeDisabled(useDefault) {
        var $form = getBranchModelForm();
        var $releaseCheckbox = $form.find('#RELEASE-enabled');
        var $productionInput = $form.find('#PRODUCTION');
        var releaseEnabled = $releaseCheckbox.prop('checked');
        var productionDefined = !!$productionInput.val();
        var disableAutoMerge = !(releaseEnabled || productionDefined);
        var $autoMerge = $form.find('#auto-merge');
        $autoMerge.prop('disabled', disableAutoMerge);
        if (useDefault) {
            $autoMerge.prop('checked', AUTOMERGE_DEFAULT);
        } else if (disableAutoMerge) {
            $autoMerge.prop('checked', false);
        }
    }

    function initToggleAutoMerge() {
        var $form = getBranchModelForm();
        $form.on('change', '#RELEASE-enabled', function() {
            setAutoMergeDisabled();
        });
        var refChangeHandler = function (refSelector, refSelectorId) {
            if (refSelectorId === 'PRODUCTION') {
                setAutoMergeDisabled();
            }
        };
        eventsApi.on('stash.feature.repository.revisionReferenceSelector.revisionRefChanged', refChangeHandler);
        eventsApi.on('stash.feature.repository.revisionReferenceSelector.revisionRefUnselected', refChangeHandler);
        setAutoMergeDisabled();
    }

    exports.onReady = function(defaultBranchModel) {
        initToggleModelEnabled();
        initTogglePrefixInputs();
        initWelcomeMatButton();
        initResetButton(defaultBranchModel);
        initToggleAutoMerge();
    };

});
