define('feature/branch-info/changeset', [
    'jquery',
    'model/page-state',
    'widget/list-branches-help-dialog',
    'feature/branch-info/common',
    'exports'
], function (
    $,
    pageState,
    listBranchesDialog,
    branchInfo,
    exports
) {
    exports.fetchContext = function(ctx) {
        branchInfo.queryBranchInfoAndDecorate(
            ctx,
            '#branch-info-placeholder',
            feature.stash.branchInfo.changeset.details,
            feature.stash.branchInfo.changeset.failed,
            function($decoration) {
                $decoration.removeClass('hidden');
            });
    };

    $(document).ready(function() {
       $('#content').on('click', '.branch-info-list-help-trigger', function(e) {
            e.preventDefault();
            listBranchesDialog.showFor(pageState.getChangeset().getId());
        });
    });
});
