define('feature/branch/ahead-behind', [
    'aui',
    'chaperone',
    'jquery',
    'exports'
], function(
    AJS,
    Chaperone,
    $,
    exports
) {
    exports.onReady = function () {
        //
        $('.ahead-behind-graph').tooltip({
            gravity: 'n',
            live: true
        });

        Chaperone.registerFeature('branch-list-discovery', [{
            id : 'branch-list-discovery',
            selector : '#repository-layout-revision-selector',
            title : AJS.I18n.getText('stash.web.branch.list.feature.discovery.title'),
            content : stash.widget.paragraph({
                text: AJS.I18n.getText('stash.web.branch.list.feature.discovery.content')
            }),
            once: true
        }]);

    };
});

jQuery(document).ready(function () {
    require('feature/branch/ahead-behind').onReady();
});