/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.branch.info.BranchInformationService;
import com.atlassian.stash.exception.ConflictingRefNameException;
import com.atlassian.stash.exception.DuplicateRefException;
import com.atlassian.stash.exception.InvalidRefNameException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.branch.BranchHasMovedException;
import com.atlassian.stash.internal.branch.BranchService;
import com.atlassian.stash.internal.branch.ForbiddenBranchException;
import com.atlassian.stash.internal.branch.UnsupportedOnBranchException;
import com.atlassian.stash.internal.branch.rest.RestBranchCreateRequest;
import com.atlassian.stash.internal.branch.rest.RestBranchDeleteRequest;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.InternalMinimalRef;
import com.atlassian.stash.repository.MinimalRef;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.rest.data.RestBranch;
import com.atlassian.stash.rest.data.RestConflictingRefNameMessage;
import com.atlassian.stash.rest.data.RestDuplicateRefMessage;
import com.atlassian.stash.rest.data.RestErrorMessage;
import com.atlassian.stash.rest.data.RestErrors;
import com.atlassian.stash.rest.data.RestInvalidRefNameMessage;
import com.atlassian.stash.rest.data.RestMinimalRef;
import com.atlassian.stash.rest.data.RestPage;
import com.atlassian.stash.rest.docs.RestDocletHelper;
import com.atlassian.stash.rest.util.ResponseFactory;
import com.atlassian.stash.rest.util.RestResource;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="projects/{projectKey}/repos/{repositorySlug}/branches")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@AnonymousAllowed
public class BranchUtilsResource
extends RestResource {
    private final BranchService branchService;
    private final BranchInformationService branchInformationService;
    private static final RestPage<RestMinimalRef> BRANCH_INFO_EXAMPLE = RestDocletHelper.pageOf((Object[])new RestMinimalRef[]{new RestMinimalRef((MinimalRef)((InternalMinimalRef.Builder)((InternalMinimalRef.Builder)new InternalMinimalRef.Builder().id("refs/heads/branch-a")).displayId("branch-a")).build()), new RestMinimalRef((MinimalRef)((InternalMinimalRef.Builder)((InternalMinimalRef.Builder)new InternalMinimalRef.Builder().id("refs/heads/branch-b")).displayId("branch-b")).build())});

    public BranchUtilsResource(BranchService branchService, BranchInformationService branchInformationService, I18nService i18nService) {
        super(i18nService);
        this.branchService = branchService;
        this.branchInformationService = branchInformationService;
    }

    @POST
    public Response createBranch(@Context Repository repository, RestBranchCreateRequest restBranchCreateRequest) {
        Response response;
        try {
            Branch branch = this.branchService.createBranch(repository, restBranchCreateRequest.getName(), restBranchCreateRequest.getStartPoint());
            response = ResponseFactory.status((Response.Status)Response.Status.CREATED).entity((Object)new RestBranch(branch)).build();
        }
        catch (ForbiddenBranchException e) {
            response = this.newErrorResponse(Response.Status.UNAUTHORIZED, new RestErrorMessage("name", (Exception)((Object)e)));
        }
        catch (DuplicateRefException e) {
            response = this.newErrorResponse(Response.Status.BAD_REQUEST, (RestErrorMessage)new RestDuplicateRefMessage("name", e));
        }
        catch (ConflictingRefNameException e) {
            response = this.newErrorResponse(Response.Status.CONFLICT, (RestErrorMessage)new RestConflictingRefNameMessage("name", e));
        }
        catch (InvalidRefNameException e) {
            response = this.newErrorResponse(Response.Status.BAD_REQUEST, (RestErrorMessage)new RestInvalidRefNameMessage("name", e));
        }
        return response;
    }

    @DELETE
    public Response deleteBranch(@Context Repository repository, RestBranchDeleteRequest restBranchDeleteRequest) {
        Response response;
        try {
            this.branchService.deleteBranch(repository, restBranchDeleteRequest.getName(), restBranchDeleteRequest.getEndPoint(), restBranchDeleteRequest.isDryRun());
            response = ResponseFactory.noContent().build();
        }
        catch (ForbiddenBranchException e) {
            response = this.newErrorResponse(Response.Status.UNAUTHORIZED, new RestErrorMessage("name", (Exception)((Object)e)));
        }
        catch (InvalidRefNameException e) {
            response = this.newErrorResponse(Response.Status.BAD_REQUEST, new RestErrorMessage("name", (Exception)((Object)e)));
        }
        catch (UnsupportedOnBranchException e) {
            response = this.newErrorResponse(Response.Status.BAD_REQUEST, new RestErrorMessage("name", (Exception)((Object)e)));
        }
        catch (BranchHasMovedException e) {
            response = this.newErrorResponse(Response.Status.BAD_REQUEST, new RestErrorMessage("endPoint", (Exception)((Object)e)));
        }
        return response;
    }

    @GET
    @Path(value="info/{changesetId}")
    public Response getBranches(@Context Repository repository, @Context PageRequest pageRequest, @PathParam(value="changesetId") String changeset) {
        Page<Branch> branches = this.branchInformationService.getBranches(repository, changeset, pageRequest);
        return ResponseFactory.ok((Object)new RestPage(branches, RestBranch.REST_TRANSFORM)).build();
    }

    private Response newErrorResponse(Response.Status status, RestErrorMessage error) {
        RestErrors restErrors = new RestErrors(error);
        return ResponseFactory.status((Response.Status)status).entity((Object)restErrors).build();
    }
}

