/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.web;

import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.exception.ArgumentValidationException;
import com.atlassian.stash.internal.branch.automerge.AutoMergeConfig;
import com.atlassian.stash.internal.branch.model.BranchTypes;
import com.atlassian.stash.internal.branch.model.configuration.BranchConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.BranchModelConfigurationRequest;
import com.atlassian.stash.internal.branch.model.configuration.BranchModelConfigurationService;
import com.atlassian.stash.internal.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.SimpleBranchConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.SimpleBranchModelConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.SimpleBranchTypeConfiguration;
import com.atlassian.stash.internal.branch.model.exception.BranchModelConfigurationException;
import com.atlassian.stash.repository.RefService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.user.PermissionValidationService;
import com.atlassian.stash.validation.FormErrors;
import com.atlassian.stash.validation.SimpleFormErrors;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class BranchModelSettingsServlet
extends HttpServlet {
    private static final String PROJECTS = "projects";
    private static final String REPOS = "repos";
    private static final String RESOURCE_KEY = "com.atlassian.stash.stash-branch-utils:server-side-templates";
    private static final String TEMPLATE_KEY = "stash.page.branchmodel.branchModelSettings";
    private static final String SETTINGS_PAGE_CONTEXT = "stash.page.branch.model.settings";
    private static final String DEVELOPMENT_BRANCH_FIELD_NAME = "DEVELOPMENT";
    private static final String PRODUCTION_BRANCH_FIELD_NAME = "PRODUCTION";
    private static final String DEFAULT_BRANCH_VALUE = "/USE_DEFAULT/";
    private static final String ENABLED_FIELD_SUFFIX = "-enabled";
    private static final String PREFIX_FIELD_SUFFIX = "-prefix";
    private static final String AUTO_MERGE_FIELD_NAME = "auto-merge";
    private static final String UPDATED_SESSION_KEY = "branchModelServlet-updated";
    private final AutoMergeConfig autoMergeConfig;
    private final BranchModelConfigurationService branchModelConfigurationService;
    private final PageBuilderService pageBuilderService;
    private final PermissionValidationService permissionValidationService;
    private final RefService refService;
    private final RepositoryService repositoryService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public BranchModelSettingsServlet(AutoMergeConfig autoMergeConfig, BranchModelConfigurationService branchModelService, PageBuilderService pageBuilderService, PermissionValidationService permissionValidationService, RefService refService, RepositoryService repositoryService, SoyTemplateRenderer soyTemplateRenderer) {
        this.autoMergeConfig = autoMergeConfig;
        this.branchModelConfigurationService = branchModelService;
        this.pageBuilderService = pageBuilderService;
        this.permissionValidationService = permissionValidationService;
        this.refService = refService;
        this.repositoryService = repositoryService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean updated = this.readUpdated(request);
        this.permissionValidationService.validateAuthenticated();
        Repository repository = this.getRepository(request, response);
        if (repository != null) {
            this.doView(updated, repository, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.permissionValidationService.validateAuthenticated();
        Repository repository = this.getRepository(request, response);
        if (repository == null) {
            return;
        }
        BranchModelConfiguration configuration = this.branchModelConfigurationService.getConfiguration(repository);
        if (this.validateUpdate(request, response, configuration)) {
            BranchModelConfigurationRequest updateRequest = this.buildBranchModelRequest(configuration, request);
            ConfigurationResult updateResult = this.doUpdate(repository, updateRequest, configuration);
            if (updateResult.getErrors().isEmpty()) {
                this.doUpdateAutoMerge(request, repository);
                this.redirectToView(request, response);
            } else {
                this.doViewAfterFailedUpdate(repository, updateRequest, updateResult.getConfiguration(), updateResult.getErrors(), request, response);
            }
        }
    }

    private Set<BranchTypeConfiguration> applyDisplayNamesFrom(BranchModelConfigurationRequest request, BranchModelConfiguration original) {
        ImmutableSet.Builder newTypes = ImmutableSet.builder();
        for (BranchTypeConfiguration typeConfiguration : request.getTypes()) {
            BranchTypes type = BranchTypes.forId(typeConfiguration.getId());
            BranchTypeConfiguration originalConfiguration = (BranchTypeConfiguration)Iterables.find(original.getTypes(), type.matcher(), null);
            if (originalConfiguration != null) {
                newTypes.add((Object)new SimpleBranchTypeConfiguration(type, originalConfiguration.getDisplayName(), typeConfiguration.isEnabled(), typeConfiguration.getPrefix()));
                continue;
            }
            newTypes.add((Object)typeConfiguration);
        }
        return newTypes.build();
    }

    private BranchModelConfigurationRequest buildBranchModelRequest(BranchModelConfiguration original, HttpServletRequest request) {
        BranchModelConfigurationRequest.Builder builder = new BranchModelConfigurationRequest.Builder(original);
        this.setDevelopment(builder, request);
        this.setProduction(builder, request);
        this.setTypes(original, request, builder);
        return builder.build();
    }

    private void setDevelopment(BranchModelConfigurationRequest.Builder updateRequestBuilder, HttpServletRequest request) {
        String developmentValue = request.getParameter(DEVELOPMENT_BRANCH_FIELD_NAME);
        if (DEFAULT_BRANCH_VALUE.equals(developmentValue)) {
            updateRequestBuilder.useDefaultAsDevelopment(true);
        } else {
            updateRequestBuilder.developmentRefId(developmentValue);
            updateRequestBuilder.useDefaultAsDevelopment(false);
        }
    }

    private void setProduction(BranchModelConfigurationRequest.Builder updateRequestBuilder, HttpServletRequest request) {
        String productionValue = StringUtils.trimToNull((String)request.getParameter(PRODUCTION_BRANCH_FIELD_NAME));
        if (productionValue == null) {
            updateRequestBuilder.useDefaultAsProduction(false);
            updateRequestBuilder.productionRefId(null);
            return;
        }
        if (DEFAULT_BRANCH_VALUE.equals(productionValue)) {
            updateRequestBuilder.useDefaultAsProduction(true);
            updateRequestBuilder.productionRefId(null);
        } else {
            updateRequestBuilder.productionRefId(productionValue);
            updateRequestBuilder.useDefaultAsProduction(false);
        }
    }

    private void setTypes(BranchModelConfiguration original, HttpServletRequest request, BranchModelConfigurationRequest.Builder builder) {
        for (BranchTypes type : BranchTypes.values()) {
            String prefix = this.getPrefixParameter(type, request);
            boolean enabled = this.getEnabledParameter(type, request);
            if (!enabled && prefix == null) {
                BranchTypeConfiguration existingConfiguration = (BranchTypeConfiguration)Iterables.find(original.getTypes(), type.matcher(), null);
                prefix = existingConfiguration != null ? existingConfiguration.getPrefix() : null;
            }
            builder.type(type.getId(), prefix, enabled);
        }
    }

    private Map<String, Object> createViewContext(Repository repository, Object branchModelConfiguration, FormErrors errors, boolean updated, boolean autoMergeOn) {
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        contextBuilder.put((Object)"repository", (Object)repository).put((Object)"enabled", (Object)(branchModelConfiguration != null ? 1 : 0)).put((Object)"autoMerge", (Object)autoMergeOn).put((Object)"updated", (Object)updated).put((Object)"defaultBranchModel", (Object)this.branchModelConfigurationService.getDefaultConfiguration());
        if (branchModelConfiguration != null) {
            contextBuilder.put((Object)"branchModel", branchModelConfiguration);
        }
        if (errors != null) {
            contextBuilder.put((Object)"errors", (Object)errors);
        }
        return contextBuilder.build();
    }

    private ConfigurationResult doUpdate(Repository repository, BranchModelConfigurationRequest updateRequest, BranchModelConfiguration originalModel) throws IOException, ServletException {
        SimpleFormErrors.Builder errorsBuilder = new SimpleFormErrors.Builder();
        BranchModelConfiguration result = originalModel;
        try {
            result = this.branchModelConfigurationService.updateConfiguration(repository, updateRequest);
        }
        catch (BranchModelConfigurationException e) {
            for (String branchTypeId : e.getTypeIds()) {
                errorsBuilder.fieldError(branchTypeId, e.getLocalizedMessage());
            }
        }
        catch (ArgumentValidationException e) {
            errorsBuilder.formError(e.getLocalizedMessage());
        }
        return new ConfigurationResult(result, (FormErrors)errorsBuilder.build());
    }

    private void doUpdateAutoMerge(HttpServletRequest request, Repository repository) {
        this.autoMergeConfig.setEnabled(repository, this.getAutoMergeFromRequest(request));
    }

    private void doView(boolean updated, Repository repository, HttpServletResponse response) throws IOException, ServletException {
        this.prepareResponse(response);
        BranchModelConfiguration branchModelConfiguration = this.branchModelConfigurationService.getConfiguration(repository);
        branchModelConfiguration = this.fixStaleRefIds(repository, branchModelConfiguration);
        this.render(response, this.createViewContext(repository, branchModelConfiguration, null, updated, this.autoMergeConfig.isEnabled(repository)));
    }

    private void doViewAfterFailedUpdate(Repository repository, BranchModelConfigurationRequest branchModelRequest, BranchModelConfiguration result, FormErrors errors, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.prepareResponse(response);
        this.render(response, this.createViewContext(repository, this.getBranchModelView(branchModelRequest, result), errors, false, this.getAutoMergeFromRequest(request)));
    }

    private boolean getAutoMergeFromRequest(HttpServletRequest request) {
        return BooleanUtils.toBoolean((String)request.getParameter(AUTO_MERGE_FIELD_NAME));
    }

    private Object getBranchModelView(BranchModelConfigurationRequest request, BranchModelConfiguration result) {
        HashMap view = Maps.newHashMap();
        view.put("development", request.getDevelopment());
        view.put("production", request.getProduction());
        view.put("types", this.applyDisplayNamesFrom(request, result));
        return view;
    }

    private BranchModelConfiguration fixStaleRefIds(Repository repository, BranchModelConfiguration config) {
        if (config == null) {
            return null;
        }
        boolean devExists = this.hasExistingRefId(repository, config.getDevelopment());
        boolean prodExists = this.hasExistingRefId(repository, config.getProduction());
        if (devExists && prodExists) {
            return config;
        }
        SimpleBranchModelConfiguration.Builder newConfig = new SimpleBranchModelConfiguration.Builder(config);
        if (!devExists) {
            newConfig.development(new SimpleBranchConfiguration(null, true));
        }
        if (!prodExists) {
            newConfig.production(null);
        }
        return newConfig.build();
    }

    private boolean getEnabledParameter(BranchTypes type, HttpServletRequest request) {
        return BooleanUtils.toBoolean((String)request.getParameter(type.getId() + ENABLED_FIELD_SUFFIX));
    }

    private String getPrefixParameter(BranchTypes type, HttpServletRequest request) {
        return request.getParameter(type.getId() + PREFIX_FIELD_SUFFIX);
    }

    private Repository getRepository(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getPathInfo();
        if (Strings.isNullOrEmpty((String)pathInfo) || pathInfo.equals("/")) {
            response.sendError(404);
            return null;
        }
        String[] pathParts = pathInfo.substring(1).split("/");
        if (!this.isRepoPath(pathParts)) {
            response.sendError(404);
            return null;
        }
        String projectKey = pathParts[1];
        String repoSlug = pathParts[3];
        Repository repository = this.repositoryService.getBySlug(projectKey, repoSlug);
        if (repository == null) {
            response.sendError(404);
        }
        return repository;
    }

    private void handleSoyError(SoyException e) throws IOException, ServletException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new ServletException((Throwable)e);
    }

    private boolean hasExistingRefId(Repository repository, BranchConfiguration configuration) {
        if (configuration != null && !configuration.isUseDefault()) {
            String devRefId = configuration.getRefId();
            return devRefId == null || this.refService.resolveRef(repository, devRefId) != null;
        }
        return true;
    }

    private boolean isRepoPath(String[] pathParts) {
        return pathParts.length == 4 && PROJECTS.equals(pathParts[0]) && REPOS.equals(pathParts[2]);
    }

    private void prepareResponse(HttpServletResponse response) {
        this.pageBuilderService.assembler().resources().requireContext(SETTINGS_PAGE_CONTEXT);
        response.setContentType("text/html;charset=UTF-8");
    }

    private boolean readUpdated(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        boolean updated = false;
        if (session != null) {
            updated = Boolean.TRUE.equals(session.getAttribute(UPDATED_SESSION_KEY));
            session.removeAttribute(UPDATED_SESSION_KEY);
        }
        return updated;
    }

    private void redirectToView(HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.getSession().setAttribute(UPDATED_SESSION_KEY, (Object)true);
        response.sendRedirect(request.getRequestURI());
    }

    private void render(HttpServletResponse response, Map<String, Object> context) throws ServletException, IOException {
        try {
            this.soyTemplateRenderer.render((Appendable)response.getWriter(), RESOURCE_KEY, TEMPLATE_KEY, context);
        }
        catch (SoyException soyException) {
            this.handleSoyError(soyException);
        }
    }

    private boolean validateUpdate(HttpServletRequest request, HttpServletResponse response, BranchModelConfiguration branchModelConfiguration) throws IOException {
        if (branchModelConfiguration == null) {
            response.sendError(409);
            return false;
        }
        if (StringUtils.isBlank((String)request.getParameter(DEVELOPMENT_BRANCH_FIELD_NAME))) {
            response.sendError(400);
            return false;
        }
        return true;
    }

    private static class ConfigurationResult {
        private final BranchModelConfiguration configuration;
        private final FormErrors errors;

        ConfigurationResult(BranchModelConfiguration configuration, FormErrors errors) {
            this.configuration = configuration;
            this.errors = errors;
        }

        BranchModelConfiguration getConfiguration() {
            return this.configuration;
        }

        FormErrors getErrors() {
            return this.errors;
        }
    }
}

