/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.version;

import com.atlassian.fugue.Option;
import com.atlassian.stash.internal.branch.model.exception.IllegalVersionStringException;
import com.atlassian.stash.internal.branch.model.version.BranchVersion;
import com.atlassian.stash.repository.Branch;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedBranch
implements Comparable<VersionedBranch> {
    private static final Logger log = LoggerFactory.getLogger(VersionedBranch.class);
    public static final Function<VersionedBranch, Branch> TO_BRANCH = new Function<VersionedBranch, Branch>(){

        public Branch apply(VersionedBranch versionedBranch) {
            return versionedBranch.getBranch();
        }
    };
    private final Branch branch;
    private final BranchVersion version;

    public VersionedBranch(@Nonnull Branch branch, @Nonnull BranchVersion version) {
        this.branch = (Branch)Preconditions.checkNotNull((Object)branch, (Object)"branch");
        this.version = (BranchVersion)Preconditions.checkNotNull((Object)version, (Object)"version");
    }

    public static Function<Branch, Option<VersionedBranch>> fromBranch(final String prefix, final @Nonnull String versionComponentSeparators) {
        return new Function<Branch, Option<VersionedBranch>>(){

            public Option<VersionedBranch> apply(Branch branch) {
                try {
                    String version = branch.getDisplayId();
                    if (prefix != null) {
                        version = version.substring(prefix.length());
                    }
                    return Option.some((Object)new VersionedBranch(branch, BranchVersion.parse(version, versionComponentSeparators)));
                }
                catch (IllegalVersionStringException e) {
                    log.debug("Branch '{}' is not a VersionedBranch (error: '{}')", (Object)branch.getDisplayId(), (Object)e.getMessage());
                    return Option.none();
                }
            }
        };
    }

    @Nonnull
    public Branch getBranch() {
        return this.branch;
    }

    @Nonnull
    public BranchVersion getVersion() {
        return this.version;
    }

    @Nonnull
    public Predicate<VersionedBranch> isCompatible() {
        return new Predicate<VersionedBranch>(){

            public boolean apply(VersionedBranch that) {
                return VersionedBranch.this.version.isCompatibleWith(that.version);
            }
        };
    }

    @Nonnull
    public Predicate<VersionedBranch> isGreater() {
        return Predicates.and(this.isCompatible(), (Predicate)new Predicate<VersionedBranch>(){

            public boolean apply(VersionedBranch that) {
                return VersionedBranch.this.compareTo(that) < 0;
            }
        });
    }

    @Override
    public int compareTo(@Nonnull VersionedBranch that) {
        return this.version.compareTo(that.version);
    }
}

