/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.stash.ao.AbstractAoDao;
import com.atlassian.stash.internal.branch.model.BranchTypes;
import com.atlassian.stash.internal.branch.model.configuration.BranchConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.BranchModelConfigurationRequest;
import com.atlassian.stash.internal.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.SimpleBranchConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.SimpleBranchTypeConfiguration;
import com.atlassian.stash.internal.branch.model.dao.AoBranchModelConfiguration;
import com.atlassian.stash.internal.branch.model.dao.AoBranchTypeConfiguration;
import com.atlassian.stash.internal.branch.model.dao.BranchModelDao;
import com.atlassian.stash.internal.branch.model.dao.PersistentBranchModelConfiguration;
import com.atlassian.stash.internal.branch.model.dao.SimplePersistentBranchModelConfiguration;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang.StringUtils;

public class AoBranchModelDao
extends AbstractAoDao
implements BranchModelDao {
    public AoBranchModelDao(@Nonnull ActiveObjects ao) {
        super(ao);
    }

    @Override
    @Nonnull
    public PersistentBranchModelConfiguration create(@Nonnull Repository repository, @Nonnull BranchModelConfigurationRequest request) {
        Preconditions.checkArgument((repository.getId() != null ? 1 : 0) != 0, (Object)"Repository does not exist in the database");
        AoBranchModelConfiguration model = (AoBranchModelConfiguration)this.ao.create(AoBranchModelConfiguration.class, this.toAoModelColumns(repository.getId(), request));
        for (BranchTypeConfiguration configuration : request.getTypes()) {
            this.ao.create(AoBranchTypeConfiguration.class, this.toAoTypeColumns(model, configuration));
        }
        return this.getByRepository(repository);
    }

    @Override
    public void deleteByRepository(@Nonnull Repository repository) {
        if (repository.getId() == null) {
            return;
        }
        this.deleteAoTypes(repository);
        this.deleteAoModel(repository);
    }

    @Override
    @Nullable
    public PersistentBranchModelConfiguration getByRepository(@Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkArgument((repository.getId() != null ? 1 : 0) != 0, (Object)"Repository does not exist in the database");
        return this.toBranchModelConfiguration(this.getAoModel(repository), this.findAoTypes(repository.getId()));
    }

    @Override
    public boolean setEnabled(@Nonnull Repository repository, boolean enabled) {
        AoBranchModelConfiguration aoBranchModel = this.getAoModelForUpdate(repository);
        if (aoBranchModel.isEnabled() != enabled) {
            aoBranchModel.setEnabled(enabled);
            aoBranchModel.save();
            return true;
        }
        return false;
    }

    @Override
    public void update(@Nonnull Repository repository, @Nonnull BranchModelConfigurationRequest updateRequest) {
        AoBranchModelConfiguration aoModel = this.getAoModelForUpdate(repository);
        this.applyUpdateToDevelopment(updateRequest, aoModel);
        this.applyUpdateToProduction(updateRequest, aoModel);
        this.applyUpdateToTypes(updateRequest, aoModel, this.findAoTypes(repository.getId()));
        this.fixRefIds(aoModel);
        aoModel.save();
    }

    private void applyUpdateToTypes(BranchModelConfigurationRequest request, AoBranchModelConfiguration aoModel, AoBranchTypeConfiguration[] aoTypes) {
        Map<String, BranchTypeConfiguration> typesMap = this.toTypesMap(request.getTypes());
        for (AoBranchTypeConfiguration aoTypeConfiguration : aoTypes) {
            BranchTypeConfiguration typeConfiguration = typesMap.remove(aoTypeConfiguration.getTypeId());
            if (typeConfiguration != null) {
                aoTypeConfiguration.setEnabled(typeConfiguration.isEnabled());
                aoTypeConfiguration.setPrefix(typeConfiguration.getPrefix());
            } else {
                aoTypeConfiguration.setEnabled(false);
                aoTypeConfiguration.setPrefix(null);
            }
            this.fixPrefix(aoTypeConfiguration);
            aoTypeConfiguration.save();
        }
        for (Map.Entry<String, BranchTypeConfiguration> newType : typesMap.entrySet()) {
            this.ao.create(AoBranchTypeConfiguration.class, this.toAoTypeColumns(aoModel, newType.getValue()));
        }
    }

    private void applyUpdateToDevelopment(BranchModelConfigurationRequest updateRequest, AoBranchModelConfiguration model) {
        model.setDevelopmentBranchId(updateRequest.getDevelopment().getRefId());
        model.setDevelopmentBranchUseDefault(updateRequest.getDevelopment().isUseDefault());
    }

    private void applyUpdateToProduction(BranchModelConfigurationRequest updateRequest, AoBranchModelConfiguration model) {
        if (updateRequest.getProduction() != null) {
            model.setProductionBranchId(updateRequest.getProduction().getRefId());
            model.setProductionBranchUseDefault(updateRequest.getProduction().isUseDefault());
        } else {
            model.setProductionBranchId(null);
            model.setProductionBranchUseDefault(false);
        }
    }

    private void deleteAoTypes(Repository repository) {
        this.ao.delete((RawEntity[])this.findAoTypes(repository.getId()));
    }

    private void deleteAoModel(Repository repository) {
        AoBranchModelConfiguration model = this.getAoModel(repository);
        if (model != null) {
            this.ao.delete(new RawEntity[]{model});
        }
    }

    private AoBranchTypeConfiguration[] findAoTypes(int repositoryId) {
        return (AoBranchTypeConfiguration[])this.ao.find(AoBranchTypeConfiguration.class, Query.select().where("FK_BM_ID = ?", new Object[]{repositoryId}));
    }

    private void fixRefIds(AoBranchModelConfiguration branchModel) {
        if (branchModel.getDevelopmentBranchId() == null) {
            branchModel.setDevelopmentBranchId("");
        }
        if (branchModel.getProductionBranchId() == null) {
            branchModel.setProductionBranchId("");
        }
    }

    private void fixPrefix(AoBranchTypeConfiguration configuration) {
        if (configuration.getPrefix() == null) {
            configuration.setPrefix("");
        }
    }

    private AoBranchModelConfiguration getAoModel(Repository repository) {
        return (AoBranchModelConfiguration)this.ao.get(AoBranchModelConfiguration.class, (Object)repository.getId());
    }

    private AoBranchModelConfiguration getAoModelForUpdate(Repository repository) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkArgument((repository.getId() != null ? 1 : 0) != 0, (Object)"Repository does not exist in the database");
        AoBranchModelConfiguration aoBranchModel = this.getAoModel(repository);
        Preconditions.checkArgument((aoBranchModel != null ? 1 : 0) != 0, (Object)("No model has been created for " + repository + " yet"));
        return aoBranchModel;
    }

    private BranchConfiguration getDevelopmentBranchConfiguration(AoBranchModelConfiguration aoBranchModel) {
        return new SimpleBranchConfiguration(aoBranchModel.getDevelopmentBranchId(), aoBranchModel.isDevelopmentBranchUseDefault());
    }

    private BranchConfiguration getProductionBranchConfiguration(AoBranchModelConfiguration aoBranchModel) {
        if (StringUtils.isNotEmpty((String)aoBranchModel.getProductionBranchId()) || aoBranchModel.isProductionBranchUseDefault()) {
            return new SimpleBranchConfiguration(aoBranchModel.getProductionBranchId(), aoBranchModel.isProductionBranchUseDefault());
        }
        return null;
    }

    private void maybePut(ImmutableMap.Builder<String, Object> builder, String key, Object value) {
        if (value != null) {
            builder.put((Object)key, value);
        }
    }

    private PersistentBranchModelConfiguration toBranchModelConfiguration(AoBranchModelConfiguration aoBranchModel, AoBranchTypeConfiguration[] aoTypes) {
        if (aoBranchModel == null) {
            return null;
        }
        return ((SimplePersistentBranchModelConfiguration.Builder)((SimplePersistentBranchModelConfiguration.Builder)((SimplePersistentBranchModelConfiguration.Builder)new SimplePersistentBranchModelConfiguration.Builder().enabled(aoBranchModel.isEnabled()).development(this.getDevelopmentBranchConfiguration(aoBranchModel))).production(this.getProductionBranchConfiguration(aoBranchModel))).types(this.toTypes(aoTypes))).build();
    }

    private Set<BranchTypeConfiguration> toTypes(AoBranchTypeConfiguration[] aoTypes) {
        ImmutableSet.Builder types = ImmutableSet.builder();
        for (AoBranchTypeConfiguration aoTypeConfig : aoTypes) {
            BranchTypes type = BranchTypes.forId(aoTypeConfig.getTypeId());
            types.add((Object)new SimpleBranchTypeConfiguration(type, aoTypeConfig.isEnabled(), aoTypeConfig.getPrefix()));
        }
        return types.build();
    }

    private Map<String, BranchTypeConfiguration> toTypesMap(Set<BranchTypeConfiguration> types) {
        HashMap result = Maps.newHashMap();
        for (BranchTypeConfiguration configuration : types) {
            result.put(configuration.getId(), configuration);
        }
        return result;
    }

    private Map<String, Object> toAoTypeColumns(AoBranchModelConfiguration model, BranchTypeConfiguration config) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "FK_BM_ID", model.getRepositoryId());
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "TYPE_ID", config.getId());
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "PREFIX", Strings.nullToEmpty((String)config.getPrefix()));
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "IS_ENABLED", config.isEnabled());
        return builder.build();
    }

    private Map<String, Object> toAoModelColumns(Integer repositoryId, BranchModelConfigurationRequest request) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "REPOSITORY_ID", repositoryId);
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "IS_ENABLED", true);
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "DEV_ID", request.getDevelopment().getRefId());
        this.maybePut((ImmutableMap.Builder<String, Object>)builder, "DEV_USE_DEFAULT", request.getDevelopment().isUseDefault());
        if (request.getProduction() != null) {
            this.maybePut((ImmutableMap.Builder<String, Object>)builder, "PROD_ID", request.getProduction().getRefId());
            this.maybePut((ImmutableMap.Builder<String, Object>)builder, "PROD_USE_DEFAULT", request.getProduction().isUseDefault());
        } else {
            this.maybePut((ImmutableMap.Builder<String, Object>)builder, "PROD_ID", null);
            this.maybePut((ImmutableMap.Builder<String, Object>)builder, "PROD_USE_DEFAULT", false);
        }
        return builder.build();
    }
}

