/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.configuration.rest;

import com.atlassian.stash.internal.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.rest.RestBranchConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.rest.RestBranchTypeConfiguration;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=BranchModelConfiguration.class)
public class RestBranchModelConfiguration
extends RestMapEntity {
    public static final String USE_DEFAULT = "useDefault";
    public static final String DEVELOPMENT = "development";
    public static final String PRODUCTION = "production";
    public static final String TYPES = "types";

    public RestBranchModelConfiguration() {
    }

    public RestBranchModelConfiguration(@Nonnull BranchModelConfiguration configuration) {
        this.put(DEVELOPMENT, (Object)new RestBranchConfiguration(configuration.getDevelopment()));
        if (configuration.getProduction() != null) {
            this.put(PRODUCTION, (Object)new RestBranchConfiguration(configuration.getProduction()));
        }
        this.put(TYPES, Collections2.transform(configuration.getTypes(), RestBranchTypeConfiguration.REST_TRANSFORM));
    }

    private RestBranchModelConfiguration(Map<String, Object> json) {
        super(json);
    }

    public static RestBranchModelConfiguration valueOf(Object rawValue) {
        if (rawValue instanceof RestBranchModelConfiguration) {
            return (RestBranchModelConfiguration)((Object)rawValue);
        }
        if (rawValue instanceof Map) {
            return new RestBranchModelConfiguration((Map)rawValue);
        }
        return null;
    }

    public boolean isUseDefault() {
        return this.getBoolProperty(USE_DEFAULT);
    }

    public Iterable<RestBranchTypeConfiguration> getTypes() {
        if (this.get(TYPES) == null) {
            return Collections.emptyList();
        }
        return Iterables.transform((Iterable)((Iterable)this.get(TYPES)), RestBranchTypeConfiguration.REST_TRANSFORM);
    }

    public RestBranchConfiguration getDevelopmentBranch() {
        return RestBranchConfiguration.valueOf(this.get(DEVELOPMENT));
    }

    public RestBranchConfiguration getProductionBranch() {
        return RestBranchConfiguration.valueOf(this.get(PRODUCTION));
    }
}

