/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.configuration.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.BranchModelConfigurationRequest;
import com.atlassian.stash.internal.branch.model.configuration.BranchModelConfigurationService;
import com.atlassian.stash.internal.branch.model.configuration.rest.RestBranchModelConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.rest.RestBranchTypeConfiguration;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.rest.util.BadRequestException;
import com.atlassian.stash.rest.util.ResponseFactory;
import com.atlassian.stash.rest.util.RestResource;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.resource.Singleton;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="projects/{projectKey}/repos/{repositorySlug}/branchmodel/configuration")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@AnonymousAllowed
public class BranchModelConfigurationResource
extends RestResource {
    private final BranchModelConfigurationService configurationService;

    public BranchModelConfigurationResource(I18nService i18nService, BranchModelConfigurationService branchModelConfigurationService) {
        super(i18nService);
        this.configurationService = branchModelConfigurationService;
    }

    @GET
    public Response getBranchModelConfiguration(@Context Repository repository) {
        BranchModelConfiguration configuration = this.configurationService.getConfiguration(repository);
        if (configuration == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("stash.branchmodel.rest.error.confignotfound", new Object[]{repository}));
        }
        return ResponseFactory.ok((Object)((Object)new RestBranchModelConfiguration(configuration))).build();
    }

    @PUT
    public Response enableModel(@Context Repository repository, @HeaderParam(value="Content-Length") @DefaultValue(value="0") int contentLength, @Context ContainerRequest requestContext) {
        boolean created = this.configurationService.setEnabled(repository, true);
        BranchModelConfiguration result = contentLength > 0 ? this.applyUpdate(repository, (RestBranchModelConfiguration)((Object)requestContext.getEntity(RestBranchModelConfiguration.class))) : this.configurationService.getConfiguration(repository);
        return this.createRestPutResponse(created, requestContext, repository, result);
    }

    @DELETE
    public Response disableModel(@Context Repository repository) {
        this.configurationService.setEnabled(repository, false);
        return ResponseFactory.noContent().build();
    }

    private void addTypeTo(BranchModelConfigurationRequest.Builder requestBuilder, RestBranchTypeConfiguration typeConfig) {
        String typeId = this.getRequiredString(typeConfig, "id");
        try {
            requestBuilder.type(typeId, this.getRequiredString(typeConfig, "prefix"), typeConfig.isEnabled());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("types." + typeId, this.i18nService.getMessage("stash.branchmodel.rest.error.invalidtype", new Object[]{e.getMessage()}));
        }
    }

    private BranchModelConfiguration applyUpdate(Repository repository, RestBranchModelConfiguration entity) {
        BranchModelConfigurationRequest request = this.createRequest(entity);
        return this.configurationService.updateConfiguration(repository, request);
    }

    private BranchModelConfigurationRequest createRequest(RestBranchModelConfiguration entity) {
        if (entity == null) {
            throw new BadRequestException(this.i18nService.getMessage("stash.branchmodel.rest.error.invalidentity", new Object[0]));
        }
        if (entity.isUseDefault()) {
            return new BranchModelConfigurationRequest.Builder(this.configurationService.getDefaultConfiguration()).build();
        }
        if (entity.getDevelopmentBranch() == null) {
            throw new BadRequestException(this.i18nService.getMessage("stash.branchmodel.rest.error.nodev", new Object[0]));
        }
        BranchModelConfigurationRequest.Builder requestBuilder = new BranchModelConfigurationRequest.Builder();
        if (entity.getDevelopmentBranch().getRefId() != null) {
            requestBuilder.developmentRefId(entity.getDevelopmentBranch().getRefId());
        }
        requestBuilder.useDefaultAsDevelopment(entity.getDevelopmentBranch().isUseDefault());
        if (entity.getProductionBranch() != null) {
            requestBuilder.productionRefId(entity.getProductionBranch().getRefId()).useDefaultAsProduction(entity.getProductionBranch().isUseDefault());
        }
        if (entity.getTypes() != null) {
            for (RestBranchTypeConfiguration typeConfig : entity.getTypes()) {
                this.addTypeTo(requestBuilder, typeConfig);
            }
        }
        return requestBuilder.build();
    }

    private Response createRestPutResponse(boolean created, ContainerRequest requestContext, Repository repository, BranchModelConfiguration updateResult) {
        Response.ResponseBuilder responseBuilder;
        if (created) {
            URI location = requestContext.getRequestUriBuilder().path(repository.getProject().getKey()).path(repository.getSlug()).build(new Object[0]);
            responseBuilder = ResponseFactory.created((URI)location);
        } else {
            responseBuilder = ResponseFactory.ok();
        }
        return responseBuilder.entity((Object)new RestBranchModelConfiguration(updateResult)).build();
    }

    private String getRequiredString(RestBranchTypeConfiguration type, String key) {
        return this.getRequiredValue(type, key, String.class);
    }

    private <T> T getRequiredValue(RestBranchTypeConfiguration type, String key, Class<T> valueType) {
        T value = valueType.cast(type.get(key));
        if (value == null) {
            throw new BadRequestException("types." + key, this.i18nService.getMessage("stash.branchmodel.rest.error.valuerequired", new Object[]{key}));
        }
        return value;
    }
}

