/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.configuration;

import com.atlassian.stash.internal.branch.model.BranchTypes;
import com.atlassian.stash.internal.branch.model.configuration.BranchConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.SimpleBranchTypeConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class BranchModelConfigurationRequest {
    private final BranchConfiguration development;
    private final BranchConfiguration production;
    private final Set<BranchTypeConfiguration> types;

    private BranchModelConfigurationRequest(Builder builder) {
        this.development = new InternalBranchConfiguration(builder.developmentRefId, builder.useDefaultAsDevelopment);
        this.production = BranchModelConfigurationRequest.createProductionConfiguration(builder);
        this.types = ImmutableSet.copyOf(builder.types.values());
    }

    @Nonnull
    public BranchConfiguration getDevelopment() {
        return this.development;
    }

    @Nullable
    public BranchConfiguration getProduction() {
        return this.production;
    }

    @Nonnull
    public Set<BranchTypeConfiguration> getTypes() {
        return this.types;
    }

    private static BranchConfiguration createProductionConfiguration(Builder builder) {
        if (StringUtils.isNotEmpty((String)builder.productionRefId) || builder.useDefaultAsProduction) {
            return new InternalBranchConfiguration(builder.productionRefId, builder.useDefaultAsProduction);
        }
        return null;
    }

    private static Map<BranchTypes, BranchTypeConfiguration> toTypeMap(Set<BranchTypeConfiguration> types) {
        EnumMap result = Maps.newEnumMap(BranchTypes.class);
        for (BranchTypeConfiguration config : types) {
            result.put(BranchTypes.forId(config.getId()), config);
        }
        return result;
    }

    private static class InternalBranchConfiguration
    implements BranchConfiguration {
        private final String refId;
        private final boolean useDefaultBranch;

        public InternalBranchConfiguration(String refId, boolean useDefaultBranch) {
            this.refId = refId;
            this.useDefaultBranch = useDefaultBranch;
        }

        @Override
        @Nullable
        public String getRefId() {
            return this.refId;
        }

        @Override
        public boolean isUseDefault() {
            return this.useDefaultBranch;
        }
    }

    public static class Builder {
        private String developmentRefId;
        private boolean useDefaultAsDevelopment;
        private String productionRefId;
        private boolean useDefaultAsProduction;
        private Map<BranchTypes, BranchTypeConfiguration> types = Maps.newEnumMap(BranchTypes.class);

        public Builder() {
        }

        public Builder(@Nonnull BranchModelConfiguration configuration) {
            this.developmentRefId = configuration.getDevelopment().getRefId();
            this.useDefaultAsDevelopment = configuration.getDevelopment().isUseDefault();
            if (configuration.getProduction() != null) {
                this.productionRefId = configuration.getProduction().getRefId();
                this.useDefaultAsProduction = configuration.getProduction().isUseDefault();
            }
            this.types = BranchModelConfigurationRequest.toTypeMap(configuration.getTypes());
        }

        @Nonnull
        public Builder type(@Nonnull String id, @Nullable String prefix, boolean enabled) {
            Preconditions.checkNotNull((Object)id, (Object)"id");
            BranchTypes type = BranchTypes.forId(id);
            this.types.put(type, new SimpleBranchTypeConfiguration(type, enabled, prefix));
            return this;
        }

        @Nonnull
        public Builder enabledType(@Nonnull String id, @Nonnull String prefix) {
            return this.type(id, prefix, true);
        }

        @Nonnull
        public Builder developmentRefId(@Nullable String developmentRefId) {
            this.developmentRefId = developmentRefId;
            return this;
        }

        @Nonnull
        public Builder useDefaultAsDevelopment(boolean useDefault) {
            this.useDefaultAsDevelopment = useDefault;
            return this;
        }

        @Nonnull
        public Builder productionRefId(@Nullable String productionRefId) {
            this.productionRefId = productionRefId;
            return this;
        }

        @Nonnull
        public Builder useDefaultAsProduction(boolean useDefault) {
            this.useDefaultAsProduction = useDefault;
            return this;
        }

        @Nonnull
        public BranchModelConfigurationRequest build() {
            return new BranchModelConfigurationRequest(this);
        }
    }
}

