/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model;

import com.atlassian.fugue.Option;
import com.atlassian.stash.branch.model.BranchClassifier;
import com.atlassian.stash.branch.model.BranchType;
import com.atlassian.stash.internal.branch.model.BranchModelGraphBuilder;
import com.atlassian.stash.internal.branch.model.BranchModelNode;
import com.atlassian.stash.internal.branch.model.BranchTypes;
import com.atlassian.stash.internal.branch.model.InternalBranchModel;
import com.atlassian.stash.internal.branch.model.InternalBranchType;
import com.atlassian.stash.internal.branch.model.InternalBranchTypes;
import com.atlassian.stash.internal.branch.model.version.VersionedBranch;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.util.Chainable;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBranchModel
implements InternalBranchModel {
    private static final Logger log = LoggerFactory.getLogger(SimpleBranchModel.class);
    private final Branch development;
    private final Branch production;
    private final Set<BranchType> types;
    private final BranchClassifier classifier;
    private final String versionComponentSeparators;

    private SimpleBranchModel(Builder builder) {
        this.classifier = (BranchClassifier)Preconditions.checkNotNull((Object)builder.classifier, (Object)"classifier");
        this.development = (Branch)Preconditions.checkNotNull((Object)builder.development, (Object)"development");
        this.production = builder.production;
        this.types = builder.types.build();
        this.versionComponentSeparators = (String)Preconditions.checkNotNull((Object)builder.versionComponentSeparators, (Object)"versionComponentSeparators");
    }

    @Override
    @Nonnull
    public BranchClassifier getClassifier() {
        return this.classifier;
    }

    @Override
    @Nonnull
    public Branch getDevelopment() {
        return this.development;
    }

    @Override
    @Nullable
    public Branch getProduction() {
        return this.production;
    }

    @Override
    @Nonnull
    public Set<BranchType> getTypes() {
        return this.types;
    }

    @Override
    @Nonnull
    public BranchModelNode getMergePath(@Nonnull Branch branch) {
        BranchType type = this.classifier.getType(branch);
        LinkedHashSet<Branch> branches = new LinkedHashSet<Branch>();
        branches.add(branch);
        if (this.shouldCascadeMerge(branch, type)) {
            if (this.isRelease(type)) {
                InternalBranchType branchType2 = InternalBranchTypes.asInternalBranchType(type);
                Function<Branch, Option<VersionedBranch>> toVersionedBranch = VersionedBranch.fromBranch(branchType2.getPrefix(), this.versionComponentSeparators);
                Option start = (Option)toVersionedBranch.apply((Object)branch);
                if (start.isDefined()) {
                    Chainable downstreamReleaseBranches = Chainable.chain(this.classifier.getAllBranchesByType(type)).flatMap(toVersionedBranch).filter(((VersionedBranch)start.get()).isGreater()).sort(Ordering.natural()).transform(VersionedBranch.TO_BRANCH);
                    Iterables.addAll(branches, (Iterable)downstreamReleaseBranches);
                } else {
                    log.debug("Release branch '{}' doesn't have a valid version, not merging to any other release branch", (Object)branch.getDisplayId());
                }
            } else if (this.isProduction(branch)) {
                branches.add(this.production);
            }
            branches.add(this.development);
        }
        return BranchModelGraphBuilder.forSinglePath(branches);
    }

    private boolean isProduction(Branch branch) {
        return this.production != null && this.production.equals(branch);
    }

    private boolean isRelease(BranchType type) {
        return type != null && BranchTypes.RELEASE.getId().equals(type.getId());
    }

    private boolean shouldCascadeMerge(Branch branch, BranchType type) {
        return this.isProduction(branch) || this.isRelease(type);
    }

    static class Builder {
        private final ImmutableSortedSet.Builder<BranchType> types = new ImmutableSortedSet.Builder(BranchTypes.DEFAULT_ORDER);
        private BranchClassifier classifier;
        private Branch development;
        private Branch production;
        private String versionComponentSeparators;

        Builder() {
        }

        @Nonnull
        public Builder classifier(@Nonnull BranchClassifier value) {
            this.classifier = (BranchClassifier)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        @Nonnull
        public Builder development(@Nonnull Branch value) {
            this.development = (Branch)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        @Nonnull
        public Builder production(@Nullable Branch value) {
            this.production = value;
            return this;
        }

        @Nonnull
        public Builder types(@Nonnull Iterable<BranchType> value) {
            this.types.addAll((Iterable)Preconditions.checkNotNull(value, (Object)"value"));
            return this;
        }

        @Nonnull
        public Builder versionComponentSeparators(@Nonnull String value) {
            this.versionComponentSeparators = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        public SimpleBranchModel build() {
            return new SimpleBranchModel(this);
        }
    }
}

