/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.list.aheadbehind;

import com.atlassian.stash.commit.graph.CommitGraphContext;
import com.atlassian.stash.commit.graph.CommitGraphNode;
import com.atlassian.stash.commit.graph.TraversalCallback;
import com.atlassian.stash.commit.graph.TraversalStatus;
import com.atlassian.stash.internal.branch.list.aheadbehind.AheadBehindCount;
import com.atlassian.stash.repository.Ref;
import javax.annotation.Nonnull;

public class AheadBehindTraversalCallback
extends TraversalCallback {
    private final CommitGraphContext baseRefContext;
    private final CommitGraphContext refContext;
    private final AheadBehindCount.Builder count;
    private final Ref ref;

    public AheadBehindTraversalCallback(Ref baseRef, Ref ref) {
        this.baseRefContext = new CommitGraphContext.Builder().include(baseRef.getLatestCommit(), new String[0]).build();
        this.refContext = new CommitGraphContext.Builder().include(ref.getLatestCommit(), new String[0]).build();
        this.count = new AheadBehindCount.Builder();
        this.ref = ref;
    }

    public TraversalStatus onNode(@Nonnull CommitGraphNode node) {
        if (this.baseRefContext.visit(node)) {
            if (this.refContext.visit(node)) {
                this.baseRefContext.exclude(node.getParents());
                this.refContext.exclude(node.getParents());
            } else {
                this.count.incrementBehind();
            }
        } else if (this.refContext.visit(node)) {
            this.count.incrementAhead();
        }
        return this.baseRefContext.isTraversing() || this.refContext.isTraversing() ? TraversalStatus.CONTINUE : TraversalStatus.FINISH;
    }

    public AheadBehindCount getCount() {
        if (this.baseRefContext.isAnyNodeVisited() && this.refContext.isAnyNodeVisited()) {
            return this.count.build();
        }
        return null;
    }

    public Ref getRef() {
        return this.ref;
    }
}

