/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import org.apache.commons.lang.StringUtils;

public class CustomPreconditions {
    public static void checkRequiredString(String value) {
        if (StringUtils.isBlank((String)value)) {
            throw new IllegalArgumentException("cannot be blank");
        }
    }

    public static void checkRequiredString(String value, int maxLength) {
        if (StringUtils.isBlank((String)value)) {
            throw new IllegalArgumentException("cannot be blank");
        }
        if (value.length() > maxLength) {
            throw new IllegalArgumentException("must be between 1 and " + maxLength + " characters");
        }
    }

    public static void checkOptionalString(String value, int maxLength) {
        if (value != null) {
            if (value.trim().length() == 0) {
                throw new IllegalArgumentException("cannot be blank");
            }
            if (value.length() > maxLength) {
                throw new IllegalArgumentException("must be between 1 and " + maxLength + " characters");
            }
        }
    }
}

