/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;

@Deprecated
public class DetailedCommitsCommandParameters
extends AbstractCommandParameters {
    private final Iterable<String> changesetIds;
    private final int maxChangesPerCommit;
    private final boolean ignoreMissing;

    private DetailedCommitsCommandParameters(Iterable<String> changesetIds, int maxChangesPerCommit, boolean ignoreMissing) {
        this.changesetIds = changesetIds;
        this.maxChangesPerCommit = maxChangesPerCommit;
        this.ignoreMissing = ignoreMissing;
    }

    @Nonnull
    public Iterable<String> getChangesetIds() {
        return this.changesetIds;
    }

    public int getMaxChangesPerCommit() {
        return this.maxChangesPerCommit;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public static class Builder {
        private final ImmutableList.Builder<String> changesetIds = ImmutableList.builder();
        private int maxChangesPerCommit;
        private boolean ignoreMissing;

        public DetailedCommitsCommandParameters build() {
            if (this.maxChangesPerCommit < 1) {
                throw new IllegalStateException("The maximum number of changes to include per commit must be greater than 0");
            }
            return new DetailedCommitsCommandParameters((Iterable)this.buildChangesetIds(), this.maxChangesPerCommit, this.ignoreMissing);
        }

        public Builder changesetId(String value) {
            DetailedCommitsCommandParameters.addIf(NOT_BLANK, this.changesetIds, value);
            return this;
        }

        public Builder changesetIds(Iterable<String> values) {
            DetailedCommitsCommandParameters.addIf(NOT_BLANK, this.changesetIds, values);
            return this;
        }

        public Builder changesetIds(String value, String ... values) {
            DetailedCommitsCommandParameters.addIf(NOT_BLANK, this.changesetIds, value, values);
            return this;
        }

        public Builder maxChangesPerCommit(int value) {
            this.maxChangesPerCommit = value;
            return this;
        }

        public Builder ignoreMissing(boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        private ImmutableList<String> buildChangesetIds() {
            ImmutableList list = this.changesetIds.build();
            if (list.isEmpty()) {
                throw new IllegalStateException("At least one changeset ID must be provided to retrieve detailed commits");
            }
            return list;
        }
    }
}

