/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.property;

import com.atlassian.stash.content.AttributeSupport;
import com.atlassian.stash.content.InternalAttributeSupport;
import com.atlassian.stash.property.PropertyMap;
import com.atlassian.stash.property.PropertySupport;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;

public class SimplePropertySupport
extends InternalAttributeSupport
implements PropertySupport {
    private transient PropertyMap properties;

    public SimplePropertySupport(@Nonnull AbstractPropertyBuilder<?> builder) {
        super(builder);
        this.setProperties(builder.properties.build());
    }

    @Override
    @Nonnull
    public PropertyMap getProperties() {
        return this.properties;
    }

    public void setProperties(@Nonnull PropertyMap properties) {
        Preconditions.checkNotNull((Object)properties, (Object)"properties");
        if (this.properties != null && !this.properties.isEmpty()) {
            throw new IllegalStateException("Properties have already been set; you cannot override once set.");
        }
        this.properties = properties;
    }

    public static abstract class AbstractPropertyBuilder<B extends AbstractPropertyBuilder<B>>
    extends InternalAttributeSupport.AbstractAttributeBuilder<B> {
        protected final PropertyMap.Builder properties = new PropertyMap.Builder();

        protected AbstractPropertyBuilder() {
        }

        protected AbstractPropertyBuilder(@Nonnull PropertySupport entity) {
            super((AttributeSupport)Preconditions.checkNotNull((Object)entity, (Object)"entity"));
            this.properties(entity.getProperties());
        }

        @Nonnull
        public B property(@Nonnull String key, @Nonnull Object value) {
            this.properties.property(key, value);
            return (B)this.self();
        }

        @Nonnull
        public B properties(@Nonnull Map<String, Object> other) {
            this.properties.properties(other);
            return (B)this.self();
        }

        @Override
        @Nonnull
        protected abstract B self();
    }
}

