/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.project;

import com.atlassian.stash.project.Project;
import com.atlassian.stash.util.BuilderSupport;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractProjectRequest {
    private final String description;
    private final String key;
    private final String name;
    private final boolean publiclyAccessible;

    protected AbstractProjectRequest(String key, String name, String description, boolean publiclyAccessible) {
        this.description = description;
        this.name = name;
        this.key = key;
        this.publiclyAccessible = publiclyAccessible;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isPublic() {
        return this.publiclyAccessible;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder>
    extends BuilderSupport {
        protected String description;
        protected String key;
        protected String name;
        protected boolean publiclyAccessible;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(@Nonnull Project project) {
            Preconditions.checkNotNull((Object)project, (Object)"project");
            this.description = project.getDescription();
            this.key = project.getKey();
            this.name = project.getName();
            this.publiclyAccessible = project.isPublic();
        }

        public B description(@Nullable String value) {
            this.description = value;
            return this.self();
        }

        public B key(@Nonnull String value) {
            this.key = (String)Preconditions.checkNotNull((Object)value, (Object)"key");
            return this.self();
        }

        public B name(@Nonnull String value) {
            this.name = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
            return this.self();
        }

        public B publiclyAccessible(boolean value) {
            this.publiclyAccessible = value;
            return this.self();
        }

        protected abstract B self();
    }
}

