/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.event.pull;

import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.stash.commit.MinimalCommit;
import com.atlassian.stash.content.MinimalChangeset;
import com.atlassian.stash.event.RepositoryRefsChangedEvent;
import com.atlassian.stash.event.pull.PullRequestEvent;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestAction;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.RefChangeType;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.SimpleRefChange;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AsynchronousPreferred
public class PullRequestMergedEvent
extends PullRequestEvent
implements RepositoryRefsChangedEvent {
    private final MinimalChangeset changeset;
    private final Map<String, Object> context;
    private final String message;
    private final Collection<RefChange> refChanges;

    public PullRequestMergedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest) {
        this(source, pullRequest, null, null, Collections.emptyMap());
    }

    @Deprecated
    public PullRequestMergedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nullable MinimalChangeset changeset) {
        this(source, pullRequest, changeset, null, Collections.emptyMap());
    }

    public PullRequestMergedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nullable MinimalChangeset changeset, @Nullable String message, @Nonnull Map<String, Object> context) {
        super(source, pullRequest, PullRequestAction.MERGED);
        this.changeset = changeset;
        this.context = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(context, (Object)"context")));
        this.message = message;
        this.refChanges = changeset == null ? Collections.emptyList() : Collections.singleton(new SimpleRefChange.Builder().from(pullRequest.getToRef()).toHash(changeset.getId()).type(RefChangeType.UPDATE).build());
    }

    @Deprecated
    @Nullable
    public MinimalChangeset getChangeset() {
        return this.changeset;
    }

    @Nullable
    public MinimalCommit getCommit() {
        return (MinimalCommit)MinimalChangeset.TO_MINIMAL_COMMIT.apply((Object)this.changeset);
    }

    @Nonnull
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Override
    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return this.getPullRequest().getToRef().getRepository();
    }

    public boolean isMergedRemotely() {
        return this.changeset == null;
    }
}

