/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.repository;

import com.atlassian.stash.exception.NoSuchProjectException;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryCloneLinksRequest;
import com.atlassian.stash.repository.RepositoryCreateRequest;
import com.atlassian.stash.repository.RepositoryForkRequest;
import com.atlassian.stash.repository.RepositorySearchRequest;
import com.atlassian.stash.repository.RepositorySupplier;
import com.atlassian.stash.repository.RepositoryUpdateRequest;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.NamedLink;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface RepositoryService
extends RepositorySupplier {
    public int countByProject(@Nonnull Project var1);

    @Nonnull
    public Repository create(@Nonnull RepositoryCreateRequest var1);

    public void delete(@Nonnull Repository var1);

    @Nonnull
    public Page<? extends Repository> findAll(@Nonnull PageRequest var1);

    @Nonnull
    public Page<? extends Repository> findByOrigin(@Nonnull Repository var1, @Nonnull PageRequest var2);

    @Nonnull
    public Page<Repository> findByOwner(@Nonnull StashUser var1, @Nonnull PageRequest var2);

    @Nonnull
    public Page<? extends Repository> findByProjectKey(@Nonnull String var1, @Nonnull PageRequest var2) throws NoSuchProjectException;

    @Nullable
    public Repository findPersonalFork(@Nonnull Repository var1);

    @Nonnull
    public Page<? extends Repository> findRelated(@Nonnull Repository var1, @Nonnull PageRequest var2);

    @Nonnull
    public Repository fork(@Nonnull RepositoryForkRequest var1);

    @Override
    @Nullable
    public Repository getById(int var1);

    @Override
    @Nullable
    public Repository getBySlug(@Nonnull String var1, @Nonnull String var2);

    @Nonnull
    public Set<NamedLink> getCloneLinks(@Nonnull RepositoryCloneLinksRequest var1);

    public long getSize(@Nonnull Repository var1);

    public boolean isForkingEnabled();

    @Nonnull
    public Repository retryCreate(@Nonnull Repository var1);

    public Page<Repository> search(@Nonnull RepositorySearchRequest var1, @Nonnull PageRequest var2);

    @Nonnull
    public Repository update(@Nonnull RepositoryUpdateRequest var1);
}

