/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.repository;

import com.atlassian.stash.repository.RefOrder;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RepositoryBranchesRequest {
    private final Repository repository;
    private final String filterText;
    private final RefOrder order;

    private RepositoryBranchesRequest(Builder builder) {
        this.repository = builder.repository;
        this.filterText = builder.filterText;
        this.order = builder.order;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public String getFilterText() {
        return this.filterText;
    }

    @Nullable
    public RefOrder getOrder() {
        return this.order;
    }

    public static class Builder {
        private Repository repository;
        private String filterText;
        private RefOrder order;

        public RepositoryBranchesRequest build() {
            Preconditions.checkState((this.repository != null ? 1 : 0) != 0, (Object)"The repository must be supplied for this request");
            return new RepositoryBranchesRequest(this);
        }

        @Nonnull
        public Builder repository(@Nonnull Repository value) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)value, (Object)"repository");
            return this;
        }

        @Nonnull
        public Builder filterText(@Nullable String value) {
            this.filterText = value;
            return this;
        }

        @Nonnull
        public Builder order(@Nullable RefOrder value) {
            this.order = value;
            return this;
        }
    }
}

