/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.mail;

import com.atlassian.stash.mail.MailProtocol;
import com.atlassian.stash.validation.OptionalString;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Range;

public class MailHostConfiguration {
    @RequiredString
    private final String hostname;
    @Range(min=0L, max=65535L)
    private final Integer port;
    @OptionalString
    private final String username;
    @OptionalString
    private final String password;
    @NotNull
    private final MailProtocol protocol;
    private final boolean useStartTls;
    private final boolean requireStartTls;

    @Deprecated
    public MailHostConfiguration(String hostname, Integer port, String username, String password, boolean useStartTls) {
        this(new Builder().hostname(hostname).port(port).username(username).password(password).protocol(MailProtocol.SMTP).useStartTls(useStartTls));
    }

    private MailHostConfiguration(Builder builder) {
        this.hostname = builder.hostname;
        this.port = builder.port;
        this.username = builder.username;
        this.password = builder.password;
        this.protocol = builder.protocol;
        this.useStartTls = builder.useStartTls;
        this.requireStartTls = builder.requireStartTls;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Nonnull
    public MailProtocol getProtocol() {
        return this.protocol;
    }

    public boolean isUseTls() {
        return this.useStartTls;
    }

    public boolean isUseStartTls() {
        return this.useStartTls;
    }

    public boolean isRequireStartTls() {
        return this.requireStartTls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MailHostConfiguration that = (MailHostConfiguration)o;
        if (this.protocol != that.protocol) {
            return false;
        }
        if (this.useStartTls != that.useStartTls) {
            return false;
        }
        if (this.requireStartTls != that.requireStartTls) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public int hashCode() {
        int result = this.hostname != null ? this.hostname.hashCode() : 0;
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
        result = 31 * result + Boolean.valueOf(this.useStartTls).hashCode();
        result = 31 * result + Boolean.valueOf(this.requireStartTls).hashCode();
        return result;
    }

    public static class Builder {
        private String hostname;
        private Integer port;
        private String username;
        private String password;
        private MailProtocol protocol = MailProtocol.SMTP;
        private boolean useStartTls;
        private boolean requireStartTls;

        public Builder() {
        }

        public Builder(@Nonnull MailHostConfiguration other) {
            this.hostname(other.hostname).port(other.port).username(other.username).protocol(other.protocol).useStartTls(other.useStartTls).requireStartTls(other.requireStartTls).password(other.password);
        }

        @Nonnull
        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Nonnull
        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        @Nonnull
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        @Nonnull
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @Nonnull
        public Builder useTls(boolean useTls) {
            return this.useStartTls(useTls);
        }

        @Nonnull
        public Builder useStartTls(boolean useStartTls) {
            this.useStartTls = useStartTls;
            if (!useStartTls) {
                this.requireStartTls = false;
            }
            return this;
        }

        @Nonnull
        public Builder requireStartTls(boolean requireStartTls) {
            this.requireStartTls = requireStartTls;
            if (requireStartTls) {
                this.useStartTls = true;
            }
            return this;
        }

        @Nonnull
        public Builder protocol(MailProtocol protocol) {
            this.protocol = (MailProtocol)((Object)Preconditions.checkNotNull((Object)((Object)protocol), (Object)"protocol"));
            return this;
        }

        @Nonnull
        public MailHostConfiguration build() {
            return new MailHostConfiguration(this);
        }
    }
}

