/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.markup;

import com.atlassian.stash.markup.UrlMode;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class RenderContext {
    private final Boolean hardwrap;
    private final Boolean htmlEscaped;
    private final UrlMode urlMode;

    private RenderContext(Builder builder) {
        this.hardwrap = builder.hardwrap;
        this.htmlEscaped = builder.htmlEscaped;
        this.urlMode = builder.urlMode;
    }

    public Boolean getHardwrap() {
        return this.hardwrap;
    }

    public Boolean getHtmlEscaped() {
        return this.htmlEscaped;
    }

    @Nonnull
    public UrlMode getUrlMode() {
        return this.urlMode;
    }

    @Deprecated
    public boolean isHardwrap() {
        return Boolean.TRUE.equals(this.hardwrap);
    }

    public static class Builder {
        private Boolean hardwrap;
        private Boolean htmlEscaped;
        private UrlMode urlMode;

        public Builder() {
            this.urlMode = UrlMode.RELATIVE;
        }

        public Builder(RenderContext context) {
            this.hardwrap = context.hardwrap;
            this.htmlEscaped = context.htmlEscaped;
            this.urlMode = context.urlMode;
        }

        public RenderContext build() {
            return new RenderContext(this);
        }

        public Builder hardwrap(boolean value) {
            this.hardwrap = value;
            return this;
        }

        public Builder htmlEscape(boolean value) {
            this.htmlEscaped = value;
            return this;
        }

        public Builder urlMode(@Nonnull UrlMode value) {
            this.urlMode = (UrlMode)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"urlMode"));
            return this;
        }
    }
}

