/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.content.ContentTreeContext;
import com.atlassian.stash.scm.AbstractCommitCommandParameters;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class DirectoryCommandParameters
extends AbstractCommitCommandParameters {
    private final boolean recursive;

    private DirectoryCommandParameters(Builder builder) {
        super(builder);
        this.recursive = builder.recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Nonnull
    public ContentTreeContext toContext() {
        return new ContentTreeContext.Builder(this.getCommitId()).recursive(this.isRecursive()).build();
    }

    public static class Builder
    extends AbstractCommitCommandParameters.AbstractCommitParametersBuilder<Builder> {
        private boolean recursive;

        public DirectoryCommandParameters build() {
            if (StringUtils.isBlank((String)this.commitId)) {
                throw new IllegalStateException("A commit ID must be provided when retrieving directory contents");
            }
            return new DirectoryCommandParameters(this);
        }

        public Builder recurse(boolean value) {
            this.recursive = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

