/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.mail;

import com.atlassian.stash.i18n.I18nKey;
import com.atlassian.stash.mail.MailMessage;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class SoyMailMessageRequest {
    private String cssModuleKey;
    private Map<String, Object> context;
    private Iterable<StashUser> recipients;
    private String subject;
    private I18nKey subjectKey;
    private String soyTemplateModuleKey;
    private String soyTemplateName;
    private Function<MailMessage.Builder, MailMessage.Builder> messageEffector;

    private SoyMailMessageRequest(Builder builder) {
        this.recipients = builder.recipients.build();
        this.subject = builder.subject;
        this.subjectKey = builder.subjectKey;
        this.soyTemplateModuleKey = builder.soyTemplateModuleKey;
        this.soyTemplateName = builder.soyTemplateName;
        this.cssModuleKey = builder.cssModuleKey;
        this.context = builder.context;
        this.messageEffector = builder.messageEffector;
    }

    @NotNull
    public Map<String, Object> getContext() {
        return this.context;
    }

    @NotNull
    public String getCssModuleKey() {
        return this.cssModuleKey;
    }

    @NotNull
    public Iterable<StashUser> getRecipients() {
        return this.recipients;
    }

    @NotNull
    public String getSoyTemplateModuleKey() {
        return this.soyTemplateModuleKey;
    }

    @NotNull
    public String getSoyTemplateName() {
        return this.soyTemplateName;
    }

    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @Nullable
    public I18nKey getSubjectKey() {
        return this.subjectKey;
    }

    @NotNull
    public Function<MailMessage.Builder, MailMessage.Builder> getMessageEffector() {
        return (Function)Objects.firstNonNull(this.messageEffector, (Object)Functions.identity());
    }

    public static class Builder {
        private String cssModuleKey;
        private Map<String, Object> context;
        private final ImmutableList.Builder<StashUser> recipients = ImmutableList.builder();
        private Function<MailMessage.Builder, MailMessage.Builder> messageEffector;
        private String subject;
        private I18nKey subjectKey;
        private String soyTemplateModuleKey;
        private String soyTemplateName;

        public SoyMailMessageRequest build() {
            return new SoyMailMessageRequest(this);
        }

        public Builder cssModuleKey(@NotNull String value) {
            this.cssModuleKey = (String)Preconditions.checkNotNull((Object)value, (Object)"cssModuleKey");
            return this;
        }

        public Builder context(@NotNull Map<String, Object> value) {
            this.context = (Map)Preconditions.checkNotNull(value, (Object)"context");
            return this;
        }

        public Builder messageEffector(@Nullable Function<MailMessage.Builder, MailMessage.Builder> value) {
            this.messageEffector = value;
            return this;
        }

        public Builder recipients(@NotNull Iterable<StashUser> value) {
            this.recipients.addAll(value);
            return this;
        }

        @Deprecated
        public Builder subject(@NotNull String value) {
            this.subject = (String)Preconditions.checkNotNull((Object)value, (Object)"subject");
            return this;
        }

        public Builder subjectKey(@NotNull I18nKey value) {
            this.subjectKey = (I18nKey)Preconditions.checkNotNull((Object)value, (Object)"subjectKey");
            return this;
        }

        public Builder soyTemplateModuleKey(@NotNull String value) {
            this.soyTemplateModuleKey = (String)Preconditions.checkNotNull((Object)value, (Object)"soyTemplateModuleKey");
            return this;
        }

        public Builder soyTemplateName(@NotNull String value) {
            this.soyTemplateName = (String)Preconditions.checkNotNull((Object)value, (Object)"soyTemplateName");
            return this;
        }
    }
}

