/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.content.ContentTreeContext;
import com.atlassian.stash.scm.AbstractChangesetCommandParameters;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class DirectoryCommandParameters
extends AbstractChangesetCommandParameters {
    private final boolean recursive;

    private DirectoryCommandParameters(String changesetId, String path, boolean recursive) {
        super(changesetId, path);
        this.recursive = recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Nonnull
    public ContentTreeContext toContext() {
        return new ContentTreeContext.Builder(this.getChangesetId()).recursive(this.isRecursive()).build();
    }

    public static class Builder
    extends AbstractChangesetCommandParameters.AbstractBuilder<Builder> {
        private boolean recursive;

        public DirectoryCommandParameters build() {
            if (StringUtils.isBlank((String)this.changesetId)) {
                throw new IllegalStateException("A changeset ID must be provided when retrieving directory contents");
            }
            return new DirectoryCommandParameters(this.changesetId, this.path, this.recursive);
        }

        public Builder recurse(boolean value) {
            this.recursive = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

