/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.DiffWhitespace;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.BuilderSupport;
import com.atlassian.util.concurrent.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class DiffRequest {
    public static final int DEFAULT_CONTEXT_LINES = -1;
    private final int contextLines;
    private final Set<String> paths;
    private final Repository repository;
    private final String sinceId;
    private final String untilId;
    private final DiffWhitespace whitespace;
    private final boolean withComments;

    private DiffRequest(Builder builder) {
        this.contextLines = builder.contextLines;
        this.paths = builder.paths.build();
        this.repository = builder.repository;
        this.sinceId = builder.sinceId;
        this.untilId = builder.untilId;
        this.whitespace = builder.whitespace;
        this.withComments = builder.withComments;
    }

    public int getContextLines() {
        return this.contextLines;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nonnull
    public String getUntilId() {
        return this.untilId;
    }

    @Nonnull
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    public boolean hasContextLines() {
        return this.contextLines > -1;
    }

    public boolean isWithComments() {
        return this.withComments;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        private final Repository repository;
        private final String untilId;
        private int contextLines;
        private String sinceId;
        private DiffWhitespace whitespace;
        private boolean withComments;

        public Builder(@Nonnull DiffRequest request) {
            this.contextLines = ((DiffRequest)Preconditions.checkNotNull((Object)request, (Object)"request")).getContextLines();
            this.repository = (Repository)Preconditions.checkNotNull((Object)request.getRepository(), (Object)"request.repository");
            this.sinceId = StringUtils.trimToNull((String)request.getSinceId());
            this.untilId = (String)Preconditions.checkNotNull((Object)request.getUntilId(), (Object)"request.untilId");
            this.whitespace = (DiffWhitespace)((Object)Preconditions.checkNotNull((Object)((Object)request.getWhitespace()), (Object)"request.whitespace"));
            this.withComments = request.isWithComments();
            Builder.addIf(NOT_BLANK, this.paths, request.getPaths());
        }

        public Builder(@Nonnull Repository repository, @Nonnull String untilId) {
            Preconditions.checkNotNull((Object)untilId, (Object)"untilId");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)untilId), (Object)"An \"until\" ID is required to stream a diff");
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
            this.untilId = untilId;
            this.contextLines = -1;
            this.whitespace = DiffWhitespace.SHOW;
            this.withComments = true;
        }

        @Nonnull
        public DiffRequest build() {
            return new DiffRequest(this);
        }

        @Nonnull
        public Builder contextLines(int value) {
            this.contextLines = Math.max(-1, value);
            return this;
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.paths, value);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.paths, values);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.paths, value, values);
            return this;
        }

        @Nonnull
        public Builder sinceId(@Nullable String value) {
            this.sinceId = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder whitespace(@Nonnull DiffWhitespace value) {
            this.whitespace = (DiffWhitespace)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"value"));
            return this;
        }

        @Nonnull
        public Builder withComments(boolean value) {
            this.withComments = value;
            return this;
        }
    }
}

