/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.pull;

import com.atlassian.stash.pull.PullRequestDirection;
import com.atlassian.stash.pull.PullRequestOrder;
import com.atlassian.stash.pull.PullRequestState;
import com.atlassian.stash.util.BuilderSupport;
import com.google.common.collect.Sets;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestSearchRequest {
    public static final int MAXIMUM_BRANCHES_TO_SEARCH = 100;
    private final Collection<String> fromRefIds;
    private final Integer fromRepositoryId;
    private final PullRequestOrder order;
    private final PullRequestState state;
    private final Collection<String> toRefIds;
    private final Integer toRepositoryId;

    private PullRequestSearchRequest(Collection<String> fromRefIds, Integer fromRepositoryId, PullRequestOrder order, PullRequestState state, Collection<String> toRefIds, Integer toRepositoryId) {
        this.fromRefIds = fromRefIds;
        this.fromRepositoryId = fromRepositoryId;
        this.order = order;
        this.state = state;
        this.toRefIds = toRefIds;
        this.toRepositoryId = toRepositoryId;
    }

    @Nonnull
    public Collection<String> getFromRefIds() {
        return this.fromRefIds;
    }

    @Nullable
    public Integer getFromRepositoryId() {
        return this.fromRepositoryId;
    }

    @Nullable
    public PullRequestOrder getOrder() {
        return this.order;
    }

    @Nullable
    public PullRequestState getState() {
        return this.state;
    }

    @Nonnull
    public Collection<String> getToRefIds() {
        return this.toRefIds;
    }

    @Nullable
    public Integer getToRepositoryId() {
        return this.toRepositoryId;
    }

    public static class Builder
    extends BuilderSupport {
        private Collection<String> fromBranchIds = Sets.newHashSet();
        private Integer fromRepositoryId;
        private PullRequestOrder order;
        private PullRequestState state;
        private Collection<String> toBranchIds = Sets.newHashSet();
        private Integer toRepositoryId;

        @Nonnull
        public PullRequestSearchRequest build() {
            if (this.fromBranchIds.size() + this.toBranchIds.size() > 100) {
                throw new IllegalArgumentException("The pull request search request does not allow searching more than 100 branches");
            }
            return new PullRequestSearchRequest(this.fromBranchIds, this.fromRepositoryId, this.order, this.state, this.toBranchIds, this.toRepositoryId);
        }

        @Nonnull
        public Builder repositoryAndBranch(@Nullable PullRequestDirection direction, @Nullable Integer repositoryId, @Nullable String branch) {
            if (direction == PullRequestDirection.OUTGOING) {
                Builder.addIf(NOT_BLANK, this.fromBranchIds, branch);
                if (this.fromRepositoryId != null && (repositoryId == null || repositoryId != null && !this.fromRepositoryId.equals(repositoryId))) {
                    throw new IllegalStateException("Repository ID is already set to a different value");
                }
                this.fromRepositoryId = repositoryId;
            } else {
                Builder.addIf(NOT_BLANK, this.toBranchIds, branch);
                if (this.toRepositoryId != null && (repositoryId == null || repositoryId != null && !this.toRepositoryId.equals(repositoryId))) {
                    throw new IllegalStateException("Repository ID is already set to a different value");
                }
                this.toRepositoryId = repositoryId;
            }
            return this;
        }

        @Nonnull
        public Builder fromRepositoryId(@Nullable Integer repositoryId) {
            this.fromRepositoryId = repositoryId;
            return this;
        }

        @Nonnull
        public Builder fromBranchId(@Nullable String branchId) {
            Builder.addIf(NOT_BLANK, this.fromBranchIds, branchId);
            return this;
        }

        @Nonnull
        public Builder fromBranchIds(@Nullable Iterable<String> branchIds) {
            Builder.addIf(NOT_BLANK, this.fromBranchIds, branchIds);
            return this;
        }

        @Nonnull
        public Builder order(@Nullable PullRequestOrder order) {
            this.order = order;
            return this;
        }

        @Nonnull
        public Builder state(@Nullable PullRequestState state) {
            this.state = state;
            return this;
        }

        @Nonnull
        public Builder toRepositoryId(@Nullable Integer repositoryId) {
            this.toRepositoryId = repositoryId;
            return this;
        }

        @Nonnull
        public Builder toBranchId(@Nullable String branchId) {
            Builder.addIf(NOT_BLANK, this.toBranchIds, branchId);
            return this;
        }

        @Nonnull
        public Builder toBranchIds(@Nullable Iterable<String> branchIds) {
            Builder.addIf(NOT_BLANK, this.toBranchIds, branchIds);
            return this;
        }
    }
}

