/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class BuilderSupport {
    protected static final Predicate<String> NOT_BLANK = new Predicate<String>(){

        public boolean apply(String value) {
            return StringUtils.isNotBlank((String)value);
        }
    };

    protected static <T> boolean addIf(@Nonnull Predicate<T> predicate, @Nonnull Collection<T> collection, @Nullable T value) {
        return predicate.apply(value) && collection.add(value);
    }

    protected static <T> boolean addIf(@Nonnull Predicate<T> predicate, @Nonnull ImmutableCollection.Builder<T> builder, @Nullable T value) {
        if (predicate.apply(value)) {
            builder.add(value);
            return true;
        }
        return false;
    }

    protected static <T> void addIf(@Nonnull Predicate<T> predicate, @Nonnull ImmutableCollection.Builder<T> builder, @Nullable T value, T ... values) {
        if (BuilderSupport.addIf(predicate, builder, value) && values != null && values.length > 0) {
            BuilderSupport.addIf(predicate, builder, Arrays.asList(values));
        }
    }

    protected static <T> void addIf(@Nonnull Predicate<T> predicate, @Nonnull Collection<T> collection, @Nullable Iterable<T> values) {
        if (values != null) {
            Iterables.addAll(collection, (Iterable)Iterables.filter(values, predicate));
        }
    }

    protected static <T> void addIf(@Nonnull Predicate<T> predicate, @Nonnull ImmutableCollection.Builder<T> builder, @Nullable Iterable<T> values) {
        if (values != null) {
            builder.addAll(Iterables.filter(values, predicate));
        }
    }

    protected static String checkNotBlank(String value, String name) {
        Preconditions.checkNotNull((Object)value, (Object)name);
        Preconditions.checkArgument((!value.trim().isEmpty() ? 1 : 0) != 0, (Object)("A non-blank " + name + " is required"));
        return value;
    }
}

