/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.scm.AbstractChangesCommandParameters;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ChangesCommandParameters
extends AbstractChangesCommandParameters {
    private final String sinceId;
    private final String untilId;

    private ChangesCommandParameters(int maxChanges, Set<String> paths, String untilId, String sinceId) {
        super(maxChanges, paths);
        this.untilId = untilId;
        this.sinceId = sinceId;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nonnull
    public String getUntilId() {
        return this.untilId;
    }

    public boolean hasSinceId() {
        return StringUtils.isNotBlank((String)this.sinceId);
    }

    public static class Builder
    extends AbstractChangesCommandParameters.AbstractBuilder<Builder> {
        private String sinceId;
        private String untilId;

        public ChangesCommandParameters build() {
            if (StringUtils.isBlank((String)this.untilId)) {
                throw new IllegalStateException("An \"until\" ID is required to retrieve changes");
            }
            return new ChangesCommandParameters(this.maxChanges, (Set)this.paths.build(), this.untilId, this.sinceId);
        }

        public Builder sinceId(String value) {
            this.sinceId = value;
            return this;
        }

        public Builder untilId(String value) {
            this.untilId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

