/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.content.DiffWhitespace;
import com.atlassian.stash.scm.AbstractCommandParameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class AbstractDiffCommandParameters
extends AbstractCommandParameters {
    public static final int DEFAULT_CONTEXT_LINES = -1;
    private final int contextLines;
    private final int maxLineLength;
    private final int maxLines;
    private final Set<String> paths;
    private final DiffWhitespace whitespace;

    public AbstractDiffCommandParameters(int maxLineLength, int maxLines, int contextLines, DiffWhitespace whitespace, Set<String> paths) {
        this.contextLines = contextLines;
        this.maxLineLength = maxLineLength;
        this.maxLines = maxLines;
        this.paths = paths;
        this.whitespace = whitespace;
    }

    public int getContextLines() {
        return this.contextLines;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    public boolean hasContextLines() {
        return this.contextLines != -1;
    }

    public boolean hasPaths() {
        return !this.paths.isEmpty();
    }

    @Nonnull
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        protected final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        protected int contextLines = -1;
        protected int maxLineLength;
        protected int maxLines;
        protected DiffWhitespace whitespace = DiffWhitespace.SHOW;

        public B contextLines(int value) {
            this.contextLines = value;
            return this.self();
        }

        public B defaultContextLines() {
            this.contextLines = -1;
            return this.self();
        }

        public B maxLineLength(int value) {
            this.maxLineLength = value;
            return this.self();
        }

        public B maxLines(int value) {
            this.maxLines = value;
            return this.self();
        }

        public B path(String value) {
            AbstractDiffCommandParameters.addIf(NOT_BLANK, this.paths, value);
            return this.self();
        }

        public B paths(Iterable<String> values) {
            AbstractDiffCommandParameters.addIf(NOT_BLANK, this.paths, values);
            return this.self();
        }

        public B paths(String value, String ... values) {
            AbstractDiffCommandParameters.addIf(NOT_BLANK, this.paths, value, values);
            return this.self();
        }

        public B whitespace(@Nonnull DiffWhitespace value) {
            this.whitespace = (DiffWhitespace)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"whitespace"));
            return this.self();
        }

        protected abstract B self();
    }
}

