/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.pull;

import com.atlassian.stash.pull.PullRequestParticipant;
import com.google.common.base.Predicate;

public enum PullRequestRole {
    AUTHOR(0, true),
    REVIEWER(1, true),
    PARTICIPANT(2, false);

    private final int id;
    private final boolean explicit;

    private PullRequestRole(int id, boolean explicit) {
        this.id = id;
        this.explicit = explicit;
    }

    public static PullRequestRole fromId(int id) {
        for (PullRequestRole value : PullRequestRole.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("No PullRequestRole is associated with ID [" + id + "]");
    }

    public Predicate<PullRequestParticipant> getFilter() {
        return new Predicate<PullRequestParticipant>(){

            public boolean apply(PullRequestParticipant participant) {
                return participant.getRole() == PullRequestRole.this;
            }
        };
    }

    public int getId() {
        return this.id;
    }

    public boolean isExplicit() {
        return this.explicit;
    }
}

