/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.pull;

import com.atlassian.stash.content.DiffWhitespace;
import com.atlassian.stash.pull.AbstractPullRequestRequest;
import com.atlassian.util.concurrent.Nullable;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class PullRequestDiffRequest
extends AbstractPullRequestRequest {
    private final String path;
    private final String srcPath;
    private final DiffWhitespace whitespace;

    private PullRequestDiffRequest(int repositoryId, long pullRequestId, String path, String srcPath, DiffWhitespace whitespace) {
        super(repositoryId, pullRequestId);
        this.path = path;
        this.srcPath = srcPath;
        this.whitespace = whitespace;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getSrcPath() {
        return this.srcPath;
    }

    @Nonnull
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private final String path;
        private String srcPath;
        private DiffWhitespace whitespace;

        public Builder(int repositoryId, long pullRequestId, String path) {
            super(repositoryId, pullRequestId);
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
            this.whitespace = DiffWhitespace.SHOW;
        }

        public Builder srcPath(String value) {
            this.srcPath = value;
            return this;
        }

        public Builder whitespace(DiffWhitespace value) {
            this.whitespace = (DiffWhitespace)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"whitespace"));
            return this;
        }

        public PullRequestDiffRequest build() {
            return new PullRequestDiffRequest(this.repositoryId, this.pullRequestId, this.path, this.srcPath, this.whitespace);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

