/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.project;

import com.atlassian.stash.project.Project;
import com.atlassian.stash.user.Permission;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ProjectSearchCriteria {
    private final String name;
    private final Permission permission;

    private ProjectSearchCriteria(String name, Permission permission) {
        this.name = StringUtils.trimToNull((String)name);
        this.permission = permission;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Permission getPermission() {
        return this.permission;
    }

    public boolean hasName() {
        return StringUtils.isNotBlank((String)this.getName());
    }

    public boolean hasPermission() {
        return this.permission != null;
    }

    public static class Builder {
        private String name;
        private Permission permission;

        public Builder() {
        }

        public Builder(@Nonnull ProjectSearchCriteria criteria) {
            this.name = ((ProjectSearchCriteria)Preconditions.checkNotNull((Object)criteria, (Object)"criteria")).getName();
            this.permission = criteria.getPermission();
        }

        @Nonnull
        public ProjectSearchCriteria build() {
            return new ProjectSearchCriteria(this.name, this.permission);
        }

        @Nonnull
        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public Builder permission(@Nullable Permission value) {
            Preconditions.checkArgument((value == null || value.isResource(Project.class) ? 1 : 0) != 0, (Object)"The provided permission is not valid for projects");
            this.permission = value;
            return this;
        }
    }
}

