/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.user;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public enum Permission {
    REPO_READ(0, 1000, false, new Permission[0]),
    REPO_WRITE(1, 3000, false, REPO_READ),
    REPO_ADMIN(8, 5000, false, REPO_READ, REPO_WRITE),
    PROJECT_READ(2, 2000, false, REPO_READ),
    PROJECT_WRITE(3, 4000, false, PROJECT_READ, REPO_WRITE),
    PROJECT_ADMIN(4, 6000, false, PROJECT_WRITE, REPO_ADMIN),
    LICENSED_USER(9, 0, true, new Permission[0]),
    PROJECT_CREATE(5, 7000, true, LICENSED_USER),
    ADMIN(6, 9000, true, new Permission[]{PROJECT_CREATE, PROJECT_ADMIN}){

        @Override
        public boolean isGrantableToAll() {
            return false;
        }
    }
    ,
    SYS_ADMIN(7, 10000, true, new Permission[]{ADMIN}){

        @Override
        public boolean isGrantableToAll() {
            return false;
        }
    };

    private static Map<Integer, Permission> idToPermissionMap;
    private static Map<Integer, Permission> weightToPermissionMap;
    private final boolean global;
    private final int id;
    private final Set<Permission> inheritedPermissions;
    private final int weight;
    private Set<Permission> implyingPermissions;
    private Set<Permission> inheritingPermissions;

    private Permission(int id, int weight, boolean global, Permission ... inherited) {
        this.global = global;
        this.id = id;
        this.weight = weight;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Permission p : inherited) {
            this.appendInheritedPermissions((ImmutableSet.Builder<Permission>)builder, p);
        }
        this.inheritedPermissions = builder.build();
    }

    public Set<Permission> getImplyingPermissions() {
        if (this.implyingPermissions == null) {
            EnumSet<Permission> inheriting = EnumSet.noneOf(Permission.class);
            inheriting.addAll(this.getInheritingPermissions());
            inheriting.remove((Object)this);
            this.implyingPermissions = Collections.unmodifiableSet(inheriting);
        }
        return this.implyingPermissions;
    }

    public boolean isGrantableToAll() {
        return true;
    }

    public boolean isProjectRelated() {
        return this == PROJECT_ADMIN || this == PROJECT_WRITE || this == PROJECT_READ;
    }

    public boolean isGrantableToAnonymous() {
        return false;
    }

    public boolean isResource() {
        return !this.global;
    }

    public static Permission fromId(int id) {
        if (idToPermissionMap == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Permission permission : Permission.values()) {
                builder.put((Object)permission.getId(), (Object)permission);
            }
            idToPermissionMap = builder.build();
        }
        return idToPermissionMap.get(id);
    }

    public static Permission fromWeight(int weight) {
        if (weightToPermissionMap == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Permission permission : Permission.values()) {
                builder.put((Object)permission.getWeight(), (Object)permission);
            }
            weightToPermissionMap = builder.build();
        }
        return weightToPermissionMap.get(weight);
    }

    public static Set<Permission> getGlobalPermissions() {
        return Sets.filter(EnumSet.allOf(Permission.class), (Predicate)new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return permission.isGlobal();
            }
        });
    }

    public static Set<Permission> getResourcePermissions() {
        return Sets.filter(EnumSet.allOf(Permission.class), (Predicate)new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return permission.isResource();
            }
        });
    }

    private void appendInheritedPermissions(ImmutableSet.Builder<Permission> builder, Permission p) {
        builder.add((Object)p);
        for (Permission perm : p.getInheritedPermissions()) {
            this.appendInheritedPermissions(builder, perm);
        }
    }

    public int getId() {
        return this.id;
    }

    public Set<Permission> getInheritedPermissions() {
        return this.inheritedPermissions;
    }

    public Set<Permission> getInheritingPermissions() {
        if (this.inheritingPermissions == null) {
            EnumSet<Permission> perms = EnumSet.of(this);
            for (Permission p : Permission.values()) {
                if (!p.getInheritedPermissions().contains((Object)this)) continue;
                perms.add(p);
            }
            this.inheritingPermissions = Collections.unmodifiableSet(perms);
        }
        return this.inheritingPermissions;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isGlobal() {
        return this.global;
    }
}

