/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.repository;

import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.ScmType;
import com.atlassian.stash.validation.OptionalString;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public interface Repository {
    public static final String SLUG_REGEXP = "[\\p{Alnum}][\\w\\-\\.]*";
    public static final String NAME_REGEXP = "[\\p{Alnum}][\\w\\-\\. ]*";

    public Integer getId();

    @RequiredString(size=64, regexp="[\\p{Alnum}][\\w\\-\\.]*")
    public String getSlug();

    @RequiredString(size=64, regexp="[\\p{Alnum}][\\w\\-\\. ]*", message="{com.atlassian.stash.validation.repository.name.pattern.message}")
    public String getName();

    public ScmType getScmType();

    public Repository getOrigin();

    public Project getProject();

    public State getState();

    @OptionalString(size=255)
    public String getStatusMessage();

    public static enum State {
        INITIALISING(0, "Initialising"),
        AVAILABLE(1, "Available"),
        INITIALISATION_FAILED(2, "Failed to initialise repository");

        private static Map<Integer, State> map;
        private final int id;
        private final String statusMessage;

        private State(int id, String statusMessage) {
            this.id = id;
            this.statusMessage = statusMessage;
        }

        public int getId() {
            return this.id;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public static State fromId(int id) {
            if (map == null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (State state : State.values()) {
                    builder.put((Object)state.getId(), (Object)state);
                }
                map = builder.build();
            }
            return map.get(id);
        }
    }
}

