/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.event;

import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.stash.event.RepositoryEvent;
import com.atlassian.stash.repository.Repository;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ObjectUtils;

@AsynchronousPreferred
public class RepositoryModifiedEvent
extends RepositoryEvent {
    private final Repository oldValue;

    public RepositoryModifiedEvent(@Nonnull Object source, @Nonnull Repository oldValue, @Nonnull Repository newValue) {
        super(source, newValue);
        this.oldValue = oldValue;
    }

    @Nonnull
    public Repository getNewValue() {
        return this.getRepository();
    }

    @Nonnull
    public Repository getOldValue() {
        return this.oldValue;
    }

    public boolean isNameChanged() {
        return ObjectUtils.notEqual((Object)this.getOldValue().getName(), (Object)this.getNewValue().getName());
    }

    public boolean isSlugChanged() {
        return ObjectUtils.notEqual((Object)this.getOldValue().getSlug(), (Object)this.getNewValue().getSlug());
    }

    public boolean isStateChanged() {
        return ObjectUtils.notEqual((Object)((Object)this.getOldValue().getState()), (Object)((Object)this.getNewValue().getState()));
    }

    public boolean isOriginChanged() {
        return ObjectUtils.notEqual((Object)this.getOldValue().getOrigin(), (Object)this.getNewValue().getOrigin());
    }
}

